/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Entity Damage Entity")
@Description(value={"Make an entity damage another entity by a given amount."})
@Examples(value={"make last spawned entity damage player by 10", "make target entity damage player by 1"})
@Since(value={"2.8.0"})
public class EffEntityDamageEntity
extends Effect {
    private Expression<LivingEntity> victims;
    private Expression<Entity> attacker;
    private Expression<Number> damageAmount;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.attacker = exprs[0];
        this.victims = exprs[1];
        this.damageAmount = exprs[2];
        return true;
    }

    protected void execute(Event event) {
        Number damageAmountNum = (Number)this.damageAmount.getSingle(event);
        double damageAmount = damageAmountNum != null ? damageAmountNum.doubleValue() : 0.0;
        Entity attacker = (Entity)this.attacker.getSingle(event);
        if (attacker == null) {
            return;
        }
        for (LivingEntity victim : (LivingEntity[])this.victims.getArray(event)) {
            victim.damage(damageAmount, attacker);
        }
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String attacker = this.attacker.toString(e, d);
        String victim = this.victims.toString(e, d);
        String amount = this.damageAmount.toString(e, d);
        return String.format("make %s damage %s by %s", attacker, victim, amount);
    }

    static {
        Skript.registerEffect(EffEntityDamageEntity.class, (String[])new String[]{"make %entity% damage %livingentities% by %number%"});
    }
}

