/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Abort Creature Spawn")
@Description(value={"Abort a creature spawn event, preventing it from retrying more attempts after canceling.", "Aborting should only be done if you're blanket blocking this entity type from spawning."})
@Examples(value={"on pre creature spawn of an animal:", "\tcancel event", "\tabort creature spawn"})
@Since(value={"2.16.0"})
public class EffAbortSpawn
extends Effect {
    private static final boolean HAS_PRE_SPAWN_EVENT = Skript.classExists((String)"com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent");
    private boolean abort;

    public boolean init(Expression<?>[] exprs, int matchedPatteren, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!HAS_PRE_SPAWN_EVENT) {
            Skript.error((String)"In order to use the 'abort spawn' effect, you must be running a PaperMC server.");
            return false;
        }
        if (!this.getParser().isCurrentEvent(PreCreatureSpawnEvent.class)) {
            Skript.error((String)"The 'abort spawn' effect can only be used an a pre creature spawn event!");
            return false;
        }
        this.abort = !parseResult.hasTag("un");
        return true;
    }

    protected void execute(Event event) {
        if (event instanceof PreCreatureSpawnEvent) {
            PreCreatureSpawnEvent preCreatureSpawnEvent = (PreCreatureSpawnEvent)event;
            preCreatureSpawnEvent.setShouldAbortSpawn(this.abort);
        }
    }

    public String toString(@Nullable Event event, boolean b) {
        return (this.abort ? "" : "un") + "abort creature spawn";
    }

    static {
        Skript.registerEffect(EffAbortSpawn.class, (String[])new String[]{"[:un]abort creature spawn"});
    }
}

