/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.slot.Slot;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.nbt.NBT;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.nbt.iface.ReadWriteNBT;
import com.shanebeestudios.skbee.api.skript.base.Section;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="NBT - Modify NBT")
@Description(value={"Modify NBT of an entity/block(TileEntity)/item.", "This method is faster than the old NBT expressions, as the changes aren't applied to the object until the section is done.", "This section creates its own internal event, which means previous event-values will not work.", "**OPTIONS**:", "`entity` = Will modify the base nbt of an entity/player.", "`block` = Will modify the base nbt of a block, must be a tile entity block.", "`item` = Will modify the base nbt of an item (the components section of an item).", "`custom` = Will modify the custom nbt of an item (the \"minecraft:custom_data\" component), entity or block."})
@Examples(value={"# Item", "modify nbt of player's tool:", "\tset int tag \"test\" of nbt to 1", "# Item - Custom", "modify custom nbt of player's tool:", "\tset double tag \"points\" of nbt to 10.5", "", "# Entity", "modify nbt of player:", "\tset int tag \"SomeRealNbtTag\" of nbt to 5", "# Entity - Custom", "modify custom nbt of player:", "\tset string tag \"blah\" of nbt to \"ooo a string\"", "", "# Block", "modify nbt of target block:", "\tset short tag \"cooking_time_spent\" of nbt to 25", "# Block - Custom", "modify custom nbt of target block:", "\tset string tag \"owner\" of nbt to {_nameOfPlayer}"})
@Since(value={"3.11.0"})
public class SecModifyNBT
extends Section {
    private boolean custom;
    private Expression<?> object;
    private Trigger trigger;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        this.custom = parseResult.hasTag("custom");
        this.object = exprs[0];
        if (sectionNode == null) {
            return false;
        }
        AtomicBoolean delayed = new AtomicBoolean(false);
        Runnable afterLoading = () -> delayed.set(!this.getParser().getHasDelayBefore().isFalse());
        this.trigger = this.loadCode(sectionNode, "nbt modify", afterLoading, new Class[]{NBTEditEvent.class});
        if (delayed.get()) {
            Skript.error((String)"Delays can't be used within an NBT Modify Section");
            return false;
        }
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        Block block;
        BlockState blockState;
        Object object = this.object.getSingle(event);
        if (this.custom) {
            Block block2;
            BlockState blockState2;
            if (object instanceof Entity) {
                Entity entity = (Entity)object;
                NBT.modifyPersistentData(entity, readWriteNBT -> this.runTrigger(event, readWriteNBT.getOrCreateCompound("skbee-custom")));
            } else if (object instanceof Block && (blockState2 = (block2 = (Block)object).getState()) instanceof TileState) {
                TileState tileState = (TileState)blockState2;
                NBT.modifyPersistentData((BlockState)tileState, readWriteNBT -> {
                    ReadWriteNBT customCompound = readWriteNBT.getOrCreateCompound("skbee-custom");
                    if (readWriteNBT.hasTag("__nbtapi")) {
                        readWriteNBT.removeKey("__nbtapi");
                    }
                    this.runTrigger(event, customCompound);
                });
            } else if (object instanceof ItemStack || object instanceof ItemType || object instanceof Slot) {
                ItemUtils.modifyItems(object, itemStack -> NBT.modify(itemStack, readWriteNBT -> this.runTrigger(event, (ReadWriteNBT)readWriteNBT)));
            }
        } else if (object instanceof Entity) {
            Entity entity = (Entity)object;
            NBT.modify(entity, readWriteNBT -> this.runTrigger(event, (ReadWriteNBT)readWriteNBT));
        } else if (object instanceof Block && (blockState = (block = (Block)object).getState()) instanceof TileState) {
            TileState tileState = (TileState)blockState;
            NBT.modify((BlockState)tileState, readWriteNBT -> this.runTrigger(event, (ReadWriteNBT)readWriteNBT));
        } else if (object instanceof ItemStack || object instanceof ItemType || object instanceof Slot) {
            ItemUtils.modifyItems(object, itemStack -> NBT.modifyComponents(itemStack, readWriteNBT -> this.runTrigger(event, (ReadWriteNBT)readWriteNBT)));
        }
        return super.walk(event, false);
    }

    private void runTrigger(Event event, ReadWriteNBT nbt) {
        NBTEditEvent nbtEditEvent = new NBTEditEvent((NBTCompound)nbt);
        Variables.withLocalVariables((Event)event, (Event)nbtEditEvent, () -> TriggerItem.walk((TriggerItem)this.trigger, (Event)nbtEditEvent));
    }

    public String toString(@Nullable Event e, boolean d) {
        return "modify nbt of " + this.object.toString(e, d);
    }

    static {
        Skript.registerSection(SecModifyNBT.class, (String[])new String[]{"modify [:custom] nbt of %entity/block/itemstack/itemtype/slot%"});
        EventValues.registerEventValue(NBTEditEvent.class, NBTCompound.class, NBTEditEvent::getCompound);
    }

    private static class NBTEditEvent
    extends Event {
        private final NBTCompound compound;

        public NBTEditEvent(NBTCompound compound) {
            this.compound = compound;
        }

        public NBTCompound getCompound() {
            return this.compound;
        }

        @NotNull
        public HandlerList getHandlers() {
            throw new IllegalStateException("This event should not be called!");
        }
    }
}

