/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.nbt.NBTApi;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.nbt.NBTCustomType;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="NBT - Tag Type")
@Description(value={"Represents the NBT tag type of a tag in an NBT compound. This is mainly useful for debugging purposes."})
@Examples(value={"set {_type} to tag type of tag \"Pos\" of nbt compound of player"})
@Since(value={"1.13.1"})
public class ExprTagTypeOfNBT
extends SimpleExpression<NBTCustomType> {
    private Expression<String> tag;
    private Expression<NBTCompound> compound;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.tag = exprs[0];
        this.compound = exprs[1];
        return true;
    }

    protected NBTCustomType @Nullable [] get(Event e) {
        String tag = (String)this.tag.getSingle(e);
        NBTCompound compound = (NBTCompound)this.compound.getSingle(e);
        if (tag == null || compound == null) {
            return null;
        }
        NBTCustomType tagType = NBTApi.getTagType(compound, tag);
        if (tagType == NBTCustomType.NBTTagEnd) {
            return null;
        }
        return new NBTCustomType[]{tagType};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends NBTCustomType> getReturnType() {
        return NBTCustomType.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "nbt tag type of tag " + this.tag.toString(e, d) + " of nbt compound " + this.compound.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprTagTypeOfNBT.class, NBTCustomType.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[nbt[ ]]tag[ ]type of tag %string% of %nbtcompound%"});
    }
}

