/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.nbt.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityType;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.nbt.NBTApi;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.util.SkriptUtils;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="NBT - Spawn Entity with NBT")
@Description(value={"Spawn an entity at a location with NBT.", "The ability to spawn falling was added in 2.10.0 as a temp effect until Skript properly handles falling blocks", "with block data."})
@Examples(value={"set {_n} to nbt compound from \"{NoAI:1b}\"", "spawn sheep at player with nbt {_n}", "spawn 1 of zombie at player with nbt nbt compound from \"{NoGravity:1b}\"", "spawn an armor stand at player with nbt from \"{Small:1b,NoBasePlate:1b,Marker:1b}\"", "spawn falling snow[layers=3] at target block with nbt from \"{HurtEntities:1b}\""})
@Since(value={"1.0.0"})
public class EffSpawnEntityNBT
extends Effect {
    private Expression<Location> locations;
    @Nullable
    private Expression<EntityType> entityTypes;
    private Expression<NBTCompound> nbt;
    @Nullable
    private Expression<Number> amount;
    @Nullable
    private Expression<BlockData> blockdata;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        this.amount = matchedPattern != 1 ? null : exprs[0];
        this.entityTypes = matchedPattern != 2 ? exprs[matchedPattern] : null;
        this.locations = matchedPattern == 2 ? Direction.combine(exprs[1], exprs[2]) : Direction.combine(exprs[1 + matchedPattern], exprs[2 + matchedPattern]);
        this.nbt = exprs[matchedPattern == 2 ? 3 : 3 + matchedPattern];
        this.blockdata = matchedPattern == 2 ? exprs[0] : null;
        return true;
    }

    public void execute(@NotNull Event event) {
        Integer numberAmount;
        NBTCompound compound = (NBTCompound)this.nbt.getSingle(event);
        if (compound == null) {
            return;
        }
        Number number = numberAmount = this.amount != null ? (Number)((Number)this.amount.getSingle(event)) : (Number)1;
        if (numberAmount == null) {
            return;
        }
        int amount = numberAmount;
        for (Location loc : (Location[])this.locations.getArray(event)) {
            assert (loc != null) : this.locations;
            if (this.entityTypes != null) {
                for (EntityType entityType : (EntityType[])this.entityTypes.getArray(event)) {
                    for (int i = 0; i < amount * entityType.getAmount(); ++i) {
                        Entity spawn = entityType.data.spawn(loc, entity -> NBTApi.addNBTToEntity(entity, compound));
                        SkriptUtils.setLastSpawned(spawn);
                    }
                }
                continue;
            }
            if (this.blockdata == null) continue;
            BlockData blockData = (BlockData)this.blockdata.getSingle(event);
            if (blockData == null) {
                return;
            }
            World world = loc.getWorld();
            FallingBlock fallingBlock = world.spawnFallingBlock(loc, blockData);
            NBTApi.addNBTToEntity((Entity)fallingBlock, compound);
            SkriptUtils.setLastSpawned((Entity)fallingBlock);
        }
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String locAndNBT = " " + this.locations.toString(e, d) + " " + this.nbt.toString(e, d);
        if (this.blockdata != null) {
            return "spawn falling " + this.blockdata.toString(e, d) + locAndNBT;
        }
        assert (this.entityTypes != null);
        return "spawn " + (String)(this.amount != null ? this.amount.toString(e, d) + " " : "") + this.entityTypes.toString(e, d) + locAndNBT;
    }

    static {
        Skript.registerEffect(EffSpawnEntityNBT.class, (String[])new String[]{"spawn %entitytypes% [%directions% %locations%] with [nbt] %nbtcompound%", "spawn %number% of %entitytypes% [%directions% %locations%] with [nbt] %nbtcompound%", "spawn falling %blockdata% [%directions% %locations%] with [nbt] %nbtcompound%"});
    }
}

