/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.registry.RegistryUtils;
import com.shanebeestudios.skbee.api.util.SimpleEntryValidator;
import com.shanebeestudios.skbee.elements.itemcomponent.sections.SecToolComponent;
import io.papermc.paper.datacomponent.item.Tool;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.set.RegistrySet;
import io.papermc.paper.registry.tag.TagKey;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.util.TriState;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryValidator;

@Name(value="ItemComponent - Tool Rule Apply")
@Description(value={"Apply rules to a tool component. You can add as many as you'd like.", "See [**McWiki Tool Component**](https://minecraft.wiki/w/Data_component_format#tool) for more details.", "", "**Entries/Sections**:", "NOTE: One of either `block_types` or `block_tag` MUST be used.", "`blocks` = The blocks to match for this rule to apply (Supports ItemTypes, BlockDatas, Minecraft Tags and TagKeys).", "`speed` = If the blocks match, overrides the default mining speed (Must be a positive number). [Optional]", "`correct for drops` = If the blocks match, overrides whether or not this tool is considered correct to mine at its most efficient speed, and to drop items if the block's loot table requires it. [Optional]"})
@Examples(value={"set {_i} to a stick", "apply tool component to {_i}:", "\tdefault_mining_speed: 2.3", "\tdamage_per_block: 2", "\trules:", "\t\tapply tool rule:", "\t\t\tblocks: minecraft block tag \"minecraft:all_signs\" # Shown as a Minecraft block tag", "\t\t\tspeed: 1.0", "\t\t\tcorrect_for_drops: true", "\t\tapply tool rule:", "\t\t\tblocks: stone, granite, andesite and gravel # Shown as a list of ItemTypes", "\t\t\tspeed: 0.5", "\t\t\tcorrect_for_drops: false", "give {_i} to player"})
@Since(value={"3.8.0"})
public class SecToolRule
extends Section {
    private static final EntryValidator VALIDATOR;
    private Expression<?> blocks;
    private Expression<Number> speed;
    private Expression<Boolean> correctForDrops;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        if (!this.getParser().isCurrentEvent(SecToolComponent.ToolComponentApplyRulesEvent.class)) {
            Skript.error((String)"Tool rules can only be applied in a 'rules' section of a tool component section.");
            return false;
        }
        EntryContainer container = VALIDATOR.validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.blocks = (Expression)container.getOptional("blocks", false);
        this.speed = (Expression)container.getOptional("speed", false);
        this.correctForDrops = (Expression)container.getOptional("correct_for_drops", false);
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        if (event instanceof SecToolComponent.ToolComponentApplyRulesEvent) {
            Number num;
            SecToolComponent.ToolComponentApplyRulesEvent rulesEvent = (SecToolComponent.ToolComponentApplyRulesEvent)event;
            Tool.Builder toolBuilder = rulesEvent.getToolBuilder();
            RegistryKeySet registryKeySet = null;
            if (this.blocks != null) {
                ArrayList<TypedKey> typedKeys = new ArrayList<TypedKey>();
                for (Object object : this.blocks.getArray(event)) {
                    Registry registry;
                    TagKey tagKey;
                    RegistryKeySet keySet;
                    TypedKey typedKey;
                    if (object instanceof ItemType) {
                        ItemType itemType = (ItemType)object;
                        typedKey = TypedKey.create((RegistryKey)RegistryKey.BLOCK, (Key)itemType.getMaterial().key());
                        typedKeys.add(typedKey);
                        continue;
                    }
                    if (object instanceof BlockData) {
                        BlockData blockData = (BlockData)object;
                        typedKey = TypedKey.create((RegistryKey)RegistryKey.BLOCK, (Key)blockData.getMaterial().key());
                        typedKeys.add(typedKey);
                        continue;
                    }
                    if (object instanceof Tag) {
                        Tag tag = (Tag)object;
                        registryKeySet = RegistryUtils.getKeySet(tag, RegistryKey.BLOCK);
                        typedKeys.clear();
                        break;
                    }
                    if (object instanceof RegistryKeySet && (keySet = (RegistryKeySet)object).registryKey() == RegistryKey.BLOCK) {
                        registryKeySet = keySet;
                        typedKeys.clear();
                        break;
                    }
                    if (!(object instanceof TagKey) || (tagKey = (TagKey)object).registryKey() != RegistryKey.BLOCK || !(registry = RegistryUtils.getRegistry(RegistryKey.BLOCK)).hasTag(tagKey)) continue;
                    registryKeySet = registry.getTag(tagKey);
                    typedKeys.clear();
                    break;
                }
                if (!typedKeys.isEmpty()) {
                    registryKeySet = RegistrySet.keySet((RegistryKey)RegistryKey.BLOCK, typedKeys);
                }
            }
            Float speed = null;
            if (this.speed != null && (num = (Number)this.speed.getSingle(event)) != null) {
                speed = Float.valueOf(num.floatValue());
            }
            TriState correctForDrops = this.correctForDrops == null ? TriState.NOT_SET : TriState.byBoolean((Boolean)((Boolean)this.correctForDrops.getSingle(event)));
            Tool.Rule rule = Tool.rule(registryKeySet, speed, (TriState)correctForDrops);
            toolBuilder.addRule(rule);
        }
        return super.walk(event, false);
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "apply tool rule";
    }

    static {
        Class[] classes = (Class[])CollectionUtils.array((Object[])new Class[]{ItemType.class, BlockData.class, Tag.class, RegistryKeySet.class, TagKey.class});
        VALIDATOR = SimpleEntryValidator.builder().addOptionalEntry("blocks", classes).addOptionalEntry("speed", Number.class).addOptionalEntry("correct_for_drops", Boolean.class).build();
        Skript.registerSection(SecToolRule.class, (String[])new String[]{"apply tool rule"});
    }
}

