/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.ItemComponentUtils;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import com.shanebeestudios.skbee.api.util.MathUtil;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="ItemComponent - Max Stack Size")
@Description(value={"Represents the max stack size of an item.", "See [**MaxStackSize**](https://minecraft.wiki/w/Data_component_format#max_stack_size) on McWiki for more details.", "Requires Paper 1.21.3+", "", "**Changers**:", "- `set` = Set the max stack size, must be an integer between 1 and 99.", "- `delete` = Will remove the component from the item.", "- `reset` = Resets back to default stack size."})
@Examples(value={"set max stack size component of player's tool to 1", "reset max stack size component of player's tool"})
@Since(value={"3.6.0"})
public class ExprMaxStackSizeComponent
extends SimplePropertyExpression<Object, Number> {
    @Nullable
    public Number convert(Object itemType) {
        ItemStack itemStack = ItemUtils.getItemStackFromObjects(itemType);
        if (itemStack != null && itemStack.hasData((DataComponentType)DataComponentTypes.MAX_STACK_SIZE)) {
            return (Number)itemStack.getData(DataComponentTypes.MAX_STACK_SIZE);
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Integer n;
        Object object;
        if (delta != null && (object = delta[0]) instanceof Number) {
            Number num = (Number)object;
            n = MathUtil.clamp(num.intValue(), 1, 99);
        } else {
            n = null;
        }
        Integer maxStackSize = n;
        ItemComponentUtils.modifyComponent(this.getExpr().getArray(event), mode, DataComponentTypes.MAX_STACK_SIZE, maxStackSize);
    }

    @NotNull
    protected String getPropertyName() {
        return "max stack size component";
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        ExprMaxStackSizeComponent.register(ExprMaxStackSizeComponent.class, Number.class, (String)"max stack size component", (String)"itemstacks/itemtypes/slots");
    }
}

