/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.SimplePropertyExpression;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.FoodProperties;
import org.jetbrains.annotations.Nullable;

@Name(value="ItemComponent - Food Properties")
@Description(value={"Get the food properties of an item.", "This will only return a value if the item has a food component.", "See [Food Component](https://minecraft.wiki/w/Data_component_format#food) on McWiki for more details.", "Requires Paper 1.21.3+"})
@Examples(value={"set {_nutrition} to food nutrition of player's tool", "if food saturation of player's tool > 0:"})
@Since(value={"3.11.2"})
public class ExprFoodComponentProperties
extends SimplePropertyExpression<Object, Number> {
    private boolean saturation;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.saturation = parseResult.hasTag("saturation");
        return super.init(expressions, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Number convert(Object from) {
        return ItemUtils.getValue(from, itemStack -> {
            if (itemStack.hasData((DataComponentType)DataComponentTypes.FOOD)) {
                FoodProperties data = (FoodProperties)itemStack.getData(DataComponentTypes.FOOD);
                assert (data != null);
                if (this.saturation) {
                    return Float.valueOf(data.saturation());
                }
                return data.nutrition();
            }
            return null;
        });
    }

    protected String getPropertyName() {
        return "food " + (this.saturation ? "saturation" : "nutrition");
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        ExprFoodComponentProperties.register(ExprFoodComponentProperties.class, Number.class, (String)"food (nutrition|:saturation)", (String)"itemstacks/itemtypes/slots");
    }
}

