/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.ItemComponentUtils;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="ItemComponent - Enchantment Glint Override")
@Description(value={"Represents the enchantment glint override of an item. ", "Requires Minecraft 1.20.5+", "Overrides the enchantment glint effect on an item.", "When `true`, the item will display a glint, even without enchantments.", "When `false`, the item will not display a glint, even with enchantments.", "**Note**: If no override is applied, will return null.", "See [**EnchantmentGlintOverride**](https://minecraft.wiki/w/Data_component_format#enchantment_glint_override) on McWiki for more details.", "Requires Paper 1.21.3+", "", "**Changers**:", "- `set` = Allows you to override the glint.", "- `reset` = Reset back to default state.", "- `delete` = Will delete any value (vanilla or not)."})
@Examples(value={"set glint override of player's tool to true", "set glint override of player's tool to false"})
@Since(value={"3.6.0"})
public class ExprEnchantmentGlintOverride
extends SimplePropertyExpression<Object, Boolean> {
    @Nullable
    public Boolean convert(Object object) {
        ItemStack itemStack = ItemUtils.getItemStackFromObjects(object);
        if (itemStack != null && itemStack.hasData((DataComponentType)DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE)) {
            return (Boolean)itemStack.getData(DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE);
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Boolean bool;
        Object object;
        Boolean glint = delta != null && (object = delta[0]) instanceof Boolean ? (bool = (Boolean)object) : null;
        ItemComponentUtils.modifyComponent(this.getExpr().getArray(event), mode, DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE, glint);
    }

    @NotNull
    protected String getPropertyName() {
        return "enchantment glint override";
    }

    @NotNull
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    static {
        ExprEnchantmentGlintOverride.register(ExprEnchantmentGlintOverride.class, Boolean.class, (String)"[enchantment] glint [override]", (String)"itemstacks/itemtypes/slots");
    }
}

