/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.ItemComponentUtils;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.Enchantable;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Name(value="ItemComponent - Enchantable")
@Description(value={"If present, and applicable enchantments are available, items with the component can be enchanted in an enchanting table.", "Positive integer representing the item's enchantability. A higher value allows enchantments with a higher cost to be picked.", "Requires Paper 1.21.3+", "See [**Enchantable Component**](https://minecraft.wiki/w/Data_component_format#enchantable) on McWiki for more details.", "", "**Changers**:", "- `set` = Allows you to override the glint.", "- `reset` = Reset back to default state.", "- `delete` = Will delete any value (vanilla or not)."})
@Examples(value={"set enchantable component of player's tool to 10", "delete enchantable component of player's tool", "reset enchantable component of {_item}"})
@Since(value={"3.8.0"})
public class ExprEnchantableComponent
extends SimplePropertyExpression<Object, Number> {
    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        return super.init(expressions, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Number convert(Object from) {
        Enchantable data;
        ItemStack itemStack = ItemUtils.getItemStackFromObjects(from);
        if (itemStack != null && itemStack.hasData((DataComponentType)DataComponentTypes.ENCHANTABLE) && (data = (Enchantable)itemStack.getData(DataComponentTypes.ENCHANTABLE)) != null) {
            return data.value();
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET -> (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
            case Changer.ChangeMode.DELETE, Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            default -> null;
        };
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        int n;
        Object object;
        if (delta != null && (object = delta[0]) instanceof Number) {
            Number number = (Number)object;
            n = number.intValue();
        } else {
            n = 0;
        }
        int value = n;
        Enchantable enchantable = Enchantable.enchantable((int)Math.max(1, value));
        ItemComponentUtils.modifyComponent(this.getExpr().getArray(event), mode, DataComponentTypes.ENCHANTABLE, enchantable);
    }

    protected String getPropertyName() {
        return "enchantable component";
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        ExprEnchantableComponent.register(ExprEnchantableComponent.class, Number.class, (String)"enchantable component", (String)"itemstacks/itemtypes/slots");
    }
}

