/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ChargedProjectiles;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Name(value="ItemComponent - Charged Projectiles")
@Description(value={"The items loaded as projectiles into a crossbow. If not present, the crossbow is not charged.", "See [**Charged Projectiles Component**](https://minecraft.wiki/w/Data_component_format#charged_projectiles) on McWiki for more details.", "Requires Paper 1.21.3+", "", "**Changers**:", "- `set` = Set the items to be loaded by the crossbow.", "- `reset` = Reset back to default state.", "- `delete` = Will delete any value (vanilla or not)."})
@Examples(value={"set charged projectiles of player's tool to an arrow and a stick", "delete charged projectiles component of player's tool", "reset charged projectiles component of player's tool"})
@Since(value={"3.8.0"})
public class ExprChargedProjectilesComponent
extends SimpleExpression<Object> {
    private Expression<?> items;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.items = exprs[0];
        return true;
    }

    protected Object @Nullable [] get(Event event) {
        ArrayList projectiles = new ArrayList();
        for (Object object : this.items.getArray(event)) {
            ChargedProjectiles data;
            ItemStack itemStack = ItemUtils.getItemStackFromObjects(object);
            if (itemStack == null || !itemStack.hasData((DataComponentType)DataComponentTypes.CHARGED_PROJECTILES) || (data = (ChargedProjectiles)itemStack.getData(DataComponentTypes.CHARGED_PROJECTILES)) == null) continue;
            projectiles.addAll(data.projectiles());
        }
        return projectiles.toArray(new ItemStack[0]);
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET -> (Class[])CollectionUtils.array((Object[])new Class[]{ItemStack[].class, ItemType[].class, Slot[].class});
            case Changer.ChangeMode.DELETE, Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            default -> null;
        };
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        ChargedProjectiles.Builder builder = ChargedProjectiles.chargedProjectiles();
        if (delta != null) {
            for (Object object : delta) {
                ItemStack itemStack2 = ItemUtils.getItemStackFromObjects(object);
                if (itemStack2 == null) continue;
                builder.add(itemStack2);
            }
        }
        ChargedProjectiles chargedProjectiles = (ChargedProjectiles)builder.build();
        ItemUtils.modifyItems(this.items.getArray(event), itemStack -> {
            if (mode == Changer.ChangeMode.SET) {
                itemStack.setData(DataComponentTypes.CHARGED_PROJECTILES, (Object)chargedProjectiles);
            } else if (mode == Changer.ChangeMode.DELETE) {
                itemStack.unsetData((DataComponentType)DataComponentTypes.CHARGED_PROJECTILES);
            } else if (mode == Changer.ChangeMode.RESET) {
                itemStack.resetData((DataComponentType)DataComponentTypes.CHARGED_PROJECTILES);
            }
        });
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    public String toString(Event e, boolean d) {
        return "charged projectiles component of " + this.items.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprChargedProjectilesComponent.class, Object.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"charged projectiles [component] of %itemstacks/itemtypes/slots%", "%itemstacks/itemtypes/slots%'[s] charged projectiles [component]"});
    }
}

