/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.itemcomponent.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="ItemComponent - Bundle Contents")
@Description(value={"Represents the contents of a bundle item."})
@Examples(value={"add 100 diamonds to bundle contents of player's tool", "remove all diamonds from bundle contents of player's tool", "delete bundle contents of player's tool"})
@Since(value={"3.6.0"})
public class ExprBundleContents
extends SimpleExpression<ItemType> {
    private Expression<ItemType> itemTypes;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.itemTypes = exprs[0];
        return true;
    }

    @Nullable
    protected ItemType[] get(Event event) {
        ArrayList itemTypes = new ArrayList();
        for (ItemType itemType : (ItemType[])this.itemTypes.getArray(event)) {
            ItemMeta itemMeta = itemType.getItemMeta();
            if (!(itemMeta instanceof BundleMeta)) continue;
            BundleMeta bundleMeta = (BundleMeta)itemMeta;
            bundleMeta.getItems().forEach(itemStack -> itemTypes.add(new ItemType(itemStack)));
        }
        return itemTypes.toArray(new ItemType[0]);
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ItemType[].class});
        }
        if (mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        List<ItemStack> itemStacks = null;
        ArrayList<ItemType> changedTypes = new ArrayList<ItemType>();
        if (delta != null) {
            for (Object object : delta) {
                if (!(object instanceof ItemType)) continue;
                ItemType itemType = (ItemType)object;
                changedTypes.add(itemType);
            }
            itemStacks = ItemUtils.addItemTypesToList(changedTypes, null);
        }
        for (ItemType itemType : (ItemType[])this.itemTypes.getArray(event)) {
            ItemMeta itemMeta = itemType.getItemMeta();
            if (!(itemMeta instanceof BundleMeta)) continue;
            BundleMeta bundleMeta = (BundleMeta)itemMeta;
            if (mode == Changer.ChangeMode.SET) {
                bundleMeta.setItems(itemStacks);
            } else if (mode == Changer.ChangeMode.ADD) {
                List<ItemStack> contents = ItemUtils.addItemTypesToList(changedTypes, bundleMeta.getItems());
                bundleMeta.setItems(contents);
            } else if (mode == Changer.ChangeMode.REMOVE) {
                List<ItemStack> i = ItemUtils.removeItemTypesFromList(bundleMeta.getItems(), changedTypes);
                bundleMeta.setItems(i);
            } else if (mode == Changer.ChangeMode.DELETE) {
                bundleMeta.setItems(itemStacks);
            }
            itemType.setItemMeta(itemMeta);
        }
    }

    @NotNull
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "bundle contents of " + this.itemTypes.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprBundleContents.class, ItemType.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"bundle contents of %itemtypes%", "%itemtypes%'[s] bundle contents"});
    }
}

