/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.generator.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.generator.event.BlockPopulateEvent;
import com.shanebeestudios.skbee.api.generator.event.ChunkGenEvent;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import org.bukkit.HeightMap;
import org.bukkit.event.Event;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="ChunkGenerator - Highest Block Y")
@Description(value={"Get the highest block y at a position in a chunk in a `block pop` or `surface gen` section.", "Getting the y in a `surface gen` section requires Paper 1.21.4+"})
@Examples(value={"set {_y} to chunkdata highest y at vector(1,0,1)"})
@Since(value={"3.5.3"})
public class ExprChunkDataHighestY
extends SimpleExpression<Number> {
    private static final boolean HAS_HEIGHT = Skript.methodExists(ChunkGenerator.ChunkData.class, (String)"getHeight", (Class[])new Class[]{HeightMap.class, Integer.TYPE, Integer.TYPE});
    private Expression<Vector> vector;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.vector = exprs[0];
        return true;
    }

    protected Number @Nullable [] get(Event event) {
        Vector vector = (Vector)this.vector.getSingle(event);
        if (vector == null) {
            return null;
        }
        if (event instanceof BlockPopulateEvent) {
            BlockPopulateEvent popEvent = (BlockPopulateEvent)event;
            int x = (popEvent.getChunkX() << 4) + vector.getBlockX();
            int z = (popEvent.getChunkZ() << 4) + vector.getBlockZ();
            int highest = popEvent.getLimitedRegion().getHighestBlockYAt(x, z, HeightMap.WORLD_SURFACE_WG) - 1;
            return new Number[]{highest};
        }
        if (event instanceof ChunkGenEvent) {
            ChunkGenEvent genEvent = (ChunkGenEvent)event;
            if (HAS_HEIGHT) {
                int x = Math.clamp((long)vector.getBlockX(), 0, 15);
                int z = Math.clamp((long)vector.getBlockZ(), 0, 15);
                int highest = genEvent.getChunkData().getHeight(HeightMap.WORLD_SURFACE_WG, x, z);
                return new Number[]{highest};
            }
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "chunkdata highest y at " + this.vector.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprChunkDataHighestY.class, Number.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"chunk[ ]data highest [block] y at %vector%"});
    }
}

