/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.generator.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.generator.ChunkGen;
import com.shanebeestudios.skbee.api.generator.ChunkGenManager;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import com.shanebeestudios.skbee.elements.worldcreator.objects.BeeWorldCreator;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="ChunkGenerator - WorldCreator Generator")
@Description(value={"Set the chunk generator of a world creator."})
@Examples(value={"on load:", "\tif world \"mars\" is not loaded:", "\t\tset {_w} to world creator named \"mars\"", "\t\tset chunk generator of {_w} to chunk generator with id \"mars\"", "\t\tload world from creator {_w}"})
@Since(value={"3.5.0"})
public class EffWorldCreatorSetGenerator
extends Effect {
    private Expression<BeeWorldCreator> worldCreator;
    private Expression<String> id;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.worldCreator = exprs[0];
        this.id = exprs[1];
        return true;
    }

    protected void execute(@NotNull Event event) {
        BeeWorldCreator worldCreator = (BeeWorldCreator)this.worldCreator.getSingle(event);
        String id = (String)this.id.getSingle(event);
        if (worldCreator == null) {
            this.error("Invalid world creator: " + this.worldCreator.toString(event, true));
            return;
        }
        if (id == null) {
            this.error("Invalid id: " + this.id.toString(event, true));
            return;
        }
        ChunkGen chunkGen = ChunkGenManager.getByID(id);
        if (chunkGen == null) {
            this.error("Invalid generator: " + id);
            return;
        }
        worldCreator.setChunkGenerator(chunkGen.getChunkGenerator());
        worldCreator.setBiomeProvider(chunkGen.getBiomeGenerator());
        worldCreator.setLoadOnStart(false);
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String creator = this.worldCreator.toString(e, d);
        String id = this.id.toString(e, d);
        return "set chunk generator of " + creator + " to chunk generator with id " + id;
    }

    static {
        Skript.registerEffect(EffWorldCreatorSetGenerator.class, (String[])new String[]{"set chunk generator of %worldcreator% to chunk generator with id %string%"});
    }
}

