/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.generator.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.generator.event.BlockPopulateEvent;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import com.shanebeestudios.skbee.api.structure.StructureWrapper;
import com.shanebeestudios.skbee.api.util.MathUtil;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@Name(value="ChunkGenerator - Structure Place")
@Description(value={"Place a structure in a block populator.", "Due to the chunk not being finalized yet,", "the standard structure place effect will not work during generation.", "Since the chunk isn't finalized yet, we use a vector instead of a location,", "the vector will represent a chunk position not a world position."})
@Examples(value={"place chunkdata structure {-s} at vector({_x}, {_y}, {_z})", "place chunkdata structure {-s} at vector(0,64,0)"})
@Since(value={"3.5.0"})
public class EffChunkDataStructurePlace
extends Effect {
    private Expression<StructureWrapper> structure;
    private Expression<Vector> vector;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.structure = exprs[0];
        this.vector = exprs[1];
        return true;
    }

    protected void execute(Event event) {
        if (!(event instanceof BlockPopulateEvent)) {
            return;
        }
        BlockPopulateEvent popEvent = (BlockPopulateEvent)event;
        StructureWrapper structure = (StructureWrapper)this.structure.getSingle(event);
        Vector vector = (Vector)this.vector.getSingle(event);
        if (structure == null || vector == null) {
            return;
        }
        vector.setX((popEvent.getChunkX() << 4) + MathUtil.clamp(vector.getBlockX(), 0, 15));
        vector.setZ((popEvent.getChunkZ() << 4) + MathUtil.clamp(vector.getBlockZ(), 0, 15));
        structure.place(popEvent.getLimitedRegion(), vector);
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String structure = this.structure.toString(e, d);
        String vector = this.vector.toString(e, d);
        return "place chunkdata structure " + structure + " at " + vector;
    }

    static {
        Skript.registerEffect(EffChunkDataStructurePlace.class, (String[])new String[]{"place chunk[ ]data structure %structure% at %vector%"});
    }
}

