/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.fastboard.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.fastboard.FastBoardBase;
import com.shanebeestudios.skbee.api.fastboard.FastBoardManager;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import java.util.ArrayList;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="FastBoard - Line")
@Description(value={"Get/set/delete lines of a player's fastboard.", "Lines are valid from 1 to 15. 1 being the line at the top and 15 being the bottom (This can be changed in the config).", "Line length is unlimited.", "Supports number format on Minecraft 1.20.4+ by providing 2 strings (see examples).", "When running Paper, text components are supported."})
@Examples(value={"set line 1 of player's fastboard to \"Look mah I'm on Minecraft\"", "set line 15 of all players' fastboards to \"I CAN SEE YOU\"", "set {_line} to line 10 of player's fastboard", "", "# NumberFormat on Minecraft 1.20.4+", "set line 1 of fastboard of player to \"Player:\" and \"&b%name of player%\"", "", "# Component Support", "set line 1 of player's fastboard to mini message from \"<rainbow>OOOO RAINBOW\"", "set line 2 of player's fastboard to mini message from \"<font:uniform>OOOO Tiny Little Text\"", "set line 3 of player's fastboard to translate component of player's tool"})
@Since(value={"1.16.0"})
public class ExprFastBoardLine
extends SimpleExpression<Object> {
    private static final Class<?>[] CHANGE_TYPES;
    private Expression<Number> line;
    private Expression<Player> player;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.line = exprs[0];
        this.player = exprs[1];
        if (parseResult.hasTag("score")) {
            Skript.warning((String)"'scoreboard' is deprecated, please use 'fastboard' instead.");
        }
        return true;
    }

    protected Object @Nullable [] get(Event event) {
        Number lineNumber = (Number)this.line.getSingle(event);
        if (lineNumber == null) {
            return null;
        }
        int line = lineNumber.intValue();
        if (line < 1 || line > 15) {
            return null;
        }
        ArrayList lines = new ArrayList();
        for (Player player : (Player[])this.player.getArray(event)) {
            Object boardLine;
            FastBoardBase<?, ?> board = FastBoardManager.getBoard(player);
            if (board == null || (boardLine = board.getLine(line)) == null) continue;
            lines.add(boardLine);
        }
        return lines.toArray();
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET, Changer.ChangeMode.DELETE -> CHANGE_TYPES;
            default -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Object lineValue = delta != null ? delta[0] : null;
        Object lineFormat = delta != null && delta.length > 1 ? delta[1] : null;
        Number lineSingle = (Number)this.line.getSingle(event);
        if (lineSingle == null) {
            return;
        }
        int line = lineSingle.intValue();
        if (line < 1 || line > 15) {
            return;
        }
        for (Player player : (Player[])this.player.getArray(event)) {
            FastBoardBase<?, ?> board = FastBoardManager.getBoard(player);
            if (board == null) continue;
            if (mode == Changer.ChangeMode.SET) {
                board.setLine(line, lineValue, lineFormat);
                continue;
            }
            if (mode != Changer.ChangeMode.DELETE) continue;
            board.deleteLine(line);
        }
    }

    public boolean isSingle() {
        return this.player.isSingle();
    }

    @NotNull
    public Class<?> getReturnType() {
        return FastBoardManager.HAS_ADVENTURE ? ComponentWrapper.class : String.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "line " + this.line.toString(e, d) + " of fastboard[s] of " + this.player.toString(e, d);
    }

    static {
        Class[] classArray;
        if (FastBoardManager.HAS_ADVENTURE) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = ComponentWrapper[].class;
            classArray = classArray2;
            classArray2[1] = String[].class;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = String[].class;
        }
        CHANGE_TYPES = classArray;
        Skript.registerExpression(ExprFastBoardLine.class, Object.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"line %number% of %players%'[s] [:score|fast]board[s]", "line %number% of [:score|fast]board[s] of %players%"});
    }
}

