/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.types;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.JavaFunction;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.lang.function.SimpleJavaFunction;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.DefaultClasses;
import com.shanebeestudios.skbee.api.util.MathUtil;
import com.shanebeestudios.skbee.api.util.SkriptUtils;
import com.shanebeestudios.skbee.api.wrapper.EnumWrapper;
import org.bukkit.entity.Display;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.TextDisplay;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4d;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class Types {
    public static final String McWIKI = "See [**Display Entity Data**](https://minecraft.wiki/w/Display#Entity_data) on McWiki for more details.";
    public static final String McWiki_INTERACTION = "See [**Interaction Entity Data**](https://minecraft.wiki/w/Interaction#Entity_data) on McWiki for more details.";
    public static ClassInfo<Transformation> TRANSFORMATION;

    public static Vector3f converToVector3f(Vector vector) {
        double x = vector.getX();
        double y = vector.getY();
        double z = vector.getZ();
        return new Vector3f((float)x, (float)y, (float)z);
    }

    public static Vector converToVector(Vector3f vector3f) {
        float x = vector3f.x;
        float y = vector3f.y;
        float z = vector3f.z;
        return new Vector(x, y, z);
    }

    static {
        if (Classes.getExactClassInfo(Display.Brightness.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(Display.Brightness.class, "displaybrightness").user(new String[]{"display ?brightness(es)?"}).name("DisplayEntity - Display Brightness").description(new String[]{"Represents the brightness attributes of a Display Entity.", McWIKI}).since("2.8.0").parser(SkriptUtils.getDefaultParser()));
        }
        if (Classes.getExactClassInfo(Display.Billboard.class) == null) {
            EnumWrapper<Display.Billboard> BILLBOARD_ENUM = new EnumWrapper<Display.Billboard>(Display.Billboard.class);
            Classes.registerClass((ClassInfo)BILLBOARD_ENUM.getClassInfo("displaybillboard").user(new String[]{"display ?billboards?"}).name("DisplayEntity - Billboard").description(new String[]{"Represents the Billboard of a Display Entity.", McWIKI}).since("2.8.0"));
        }
        if (Classes.getExactClassInfo(TextDisplay.TextAlignment.class) == null) {
            EnumWrapper<TextDisplay.TextAlignment> TEXT_ALIGNMENT_ENUM = new EnumWrapper<TextDisplay.TextAlignment>(TextDisplay.TextAlignment.class, "", "aligned");
            Classes.registerClass((ClassInfo)TEXT_ALIGNMENT_ENUM.getClassInfo("textalignment").user(new String[]{"text ?alignments?"}).name("DisplayEntity - Text Alignment").description(new String[]{"Represents the text alignment of a Text Display Entity.", "NOTE: While I understand these names do not directly align with Minecraft,", "I had to suffix them to deal with conflict issues.", McWIKI}).since("2.8.0"));
        }
        if (Classes.getExactClassInfo(ItemDisplay.ItemDisplayTransform.class) == null) {
            EnumWrapper<ItemDisplay.ItemDisplayTransform> TRANSFORM_ENUM = new EnumWrapper<ItemDisplay.ItemDisplayTransform>(ItemDisplay.ItemDisplayTransform.class, "", "transform");
            Classes.registerClass((ClassInfo)TRANSFORM_ENUM.getClassInfo("itemdisplaytransform").user(new String[]{"item ?display ?transforms?"}).name("DisplayEntity - Item Display Transform").description(new String[]{"Represents the item display transform of an Item Display Entity.", McWIKI}).since("2.8.0"));
        }
        if ((TRANSFORMATION = Classes.getExactClassInfo(Transformation.class)) == null) {
            TRANSFORMATION = new ClassInfo(Transformation.class, "transformation").user(new String[]{"transformations?"}).name("DisplayEntity - Transformation").description(new String[]{"Represents a transformation of a Display Entity.", McWIKI}).since("2.8.0").parser(SkriptUtils.getDefaultParser());
            Classes.registerClass(TRANSFORMATION);
        }
        Functions.registerFunction((JavaFunction)new SimpleJavaFunction<Display.Brightness>("displayBrightness", new Parameter[]{new Parameter("blockLight", DefaultClasses.NUMBER, true, null), new Parameter("skyLight", DefaultClasses.NUMBER, true, null)}, Classes.getExactClassInfo(Display.Brightness.class), true){

            @Nullable
            public Display.Brightness[] executeSimple(Object[][] params) {
                if (params[0].length == 0 || params[1].length == 0) {
                    return null;
                }
                int block = ((Number)params[0][0]).intValue();
                int sky = ((Number)params[1][0]).intValue();
                block = MathUtil.clamp(block, 0, 15);
                sky = MathUtil.clamp(sky, 0, 15);
                return new Display.Brightness[]{new Display.Brightness(block, sky)};
            }
        }.description(new String[]{"Creates a new display brightness object for use on a Display Entity.", "Number values must be between 0 and 15.", McWIKI}).examples(new String[]{"set {_db} to displayBrightness(10,10)"}).since("2.8.0"));
        ClassInfo QUATERNION_CLASS_INFO = Classes.getExactClassInfo(Quaternionf.class);
        Functions.registerFunction((JavaFunction)new SimpleJavaFunction<Quaternionf>("vector4", new Parameter[]{new Parameter("x", DefaultClasses.NUMBER, true, null), new Parameter("y", DefaultClasses.NUMBER, true, null), new Parameter("z", DefaultClasses.NUMBER, true, null), new Parameter("w", DefaultClasses.NUMBER, true, null)}, QUATERNION_CLASS_INFO, true){

            @Nullable
            public Quaternionf[] executeSimple(Object[][] params) {
                float x = ((Number)params[0][0]).floatValue();
                float y = ((Number)params[1][0]).floatValue();
                float z = ((Number)params[2][0]).floatValue();
                float w = ((Number)params[3][0]).floatValue();
                return new Quaternionf[]{new Quaternionf(x, y, z, w)};
            }
        }.description(new String[]{"Creates a new Vector4(Quaternion).", "Use Quaternion instead, this was just a placeholder! Will be removed in the future!"}).examples(new String[]{"set {_v} to vector4(1,0,0,0)"}).since("2.8.0 (DEPRECATED)"));
        if (Functions.getGlobalFunction((String)"axisAngleFromVector") == null) {
            Functions.registerFunction((JavaFunction)new SimpleJavaFunction<Quaternionf>("axisAngleFromVector", new Parameter[]{new Parameter("angle", DefaultClasses.NUMBER, true, null), new Parameter("vector", DefaultClasses.VECTOR, true, null)}, QUATERNION_CLASS_INFO, true){

                @Nullable
                public Quaternionf[] executeSimple(Object[][] params) {
                    float angle = ((Number)params[0][0]).floatValue();
                    Vector vector = (Vector)params[1][0];
                    AxisAngle4d axisAngle4f = new AxisAngle4d((double)angle * Math.PI / 180.0, vector.getX(), vector.getY(), vector.getZ());
                    return new Quaternionf[]{new Quaternionf(axisAngle4f)};
                }
            }.description(new String[]{"Creates a new AxisAngle4f using a vector and angle (Will be converted and returned as a Quaternion).", "I have no clue what this is, ask ThatOneWizard!"}).examples(new String[]{"set {_v} to axisAngleFromVector(0.25, vector(0,0,1))"}).since("2.15.0"));
        }
        if (Functions.getGlobalFunction((String)"transformation") == null) {
            Functions.registerFunction((JavaFunction)new SimpleJavaFunction<Transformation>("transformation", new Parameter[]{new Parameter("translation", DefaultClasses.VECTOR, true, null), new Parameter("scale", DefaultClasses.VECTOR, true, null), new Parameter("leftRotation", QUATERNION_CLASS_INFO, true, null), new Parameter("rightRotation", QUATERNION_CLASS_INFO, true, null)}, TRANSFORMATION, true){

                public Transformation[] executeSimple(Object[][] params) {
                    Vector3f translation = Types.converToVector3f((Vector)params[0][0]);
                    Vector3f scale = Types.converToVector3f((Vector)params[1][0]);
                    Quaternionf leftRotation = (Quaternionf)params[2][0];
                    Quaternionf rightRotation = (Quaternionf)params[3][0];
                    return new Transformation[]{new Transformation(translation, leftRotation, scale, rightRotation)};
                }
            }.description(new String[]{"Creates a new Transformation"}).examples(new String[]{"on load:", "\tset {_trans} to vector(0,1,0)", "\tset {_scale} to vector(1,1,1)", "\tset {_lr} to quaternion(1,1,1,1)", "\tset {_rr} to axisAngle(2,2,2,2)", "\tset {_transform} to transformation({_trans}, {_scale}, {_lr}, {_rr})"}).since("2.8.0"));
        }
    }
}

