/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="DisplayEntity - Display Text")
@Description(value={"Represents the display text of a Text Display Entity.", "NOTE: Supports multiple lines.", "See [**Display Entity Data**](https://minecraft.wiki/w/Display#Entity_data) on McWiki for more details."})
@Examples(value={"set display text of {_display} to \"Line 1\", \"Line 2\" and \"Line 3\""})
@Since(value={"2.8.0"})
public class ExprTextDisplayText
extends SimplePropertyExpression<Entity, String> {
    @Nullable
    public String convert(Entity entity) {
        if (entity instanceof TextDisplay) {
            TextDisplay textDisplay = (TextDisplay)entity;
            return textDisplay.getText();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String[].class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta == null) {
            return;
        }
        String text = delta.length == 1 ? (String)delta[0] : StringUtils.join((Object[])delta, (String)"\n");
        for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
            if (!(entity instanceof TextDisplay)) continue;
            TextDisplay textDisplay = (TextDisplay)entity;
            textDisplay.setText(text);
        }
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "display text";
    }

    static {
        ExprTextDisplayText.register(ExprTextDisplayText.class, String.class, (String)"display text", (String)"entities");
    }
}

