/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="DisplayEntity - Text Shadowed")
@Description(value={"Represents the shadowed state of a Text Display Entity.", "See [**Display Entity Data**](https://minecraft.wiki/w/Display#Entity_data) on McWiki for more details."})
@Examples(value={"set display text shadowed of {_display} to true"})
@Since(value={"2.8.0"})
public class ExprTextDisplayShadowed
extends SimplePropertyExpression<Entity, Boolean> {
    @Nullable
    public Boolean convert(Entity entity) {
        if (entity instanceof TextDisplay) {
            TextDisplay textDisplay = (TextDisplay)entity;
            return textDisplay.isShadowed();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Entity[] entityArray;
        if (delta != null && (entityArray = delta[0]) instanceof Boolean) {
            Boolean shadowed = (Boolean)entityArray;
            for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
                if (!(entity instanceof TextDisplay)) continue;
                TextDisplay textDisplay = (TextDisplay)entity;
                textDisplay.setShadowed(shadowed.booleanValue());
            }
        }
    }

    @NotNull
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "text shadowed";
    }

    static {
        ExprTextDisplayShadowed.register(ExprTextDisplayShadowed.class, Boolean.class, (String)"[display] text shadowed", (String)"entities");
    }
}

