/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.MathUtil;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="DisplayEntity - Teleport Duration")
@Description(value={"Represents the time it takes for a diplay entity to teleport from one location to another.", "This works similaly to interpolation, but this uses teleportation instead of quaternions and math.", "NOTE: Due to how this works, you will need to use integers as ticks instead of time spans.", "This number is clamped between 0 and 59.", "\n0 means that updates are applied immediately.", "\n1 means that the display entity will move from current position to the updated one over one tick.", "\nHigher values spread the movement over multiple ticks.", "Requires MC 1.20.2+", "See [**Display Entity Data**](https://minecraft.wiki/w/Display#Entity_data) on McWiki for more details."})
@Examples(value={"set display teleport duration of {_display} to 30", "reset display teleport duration of {_display}", "add 10 to display teleport duration of {_display}", "remove 5 from display teleport duration of {_display}"})
@Since(value={"2.18.3"})
public class ExprDisplayTeleportDuration
extends SimplePropertyExpression<Entity, Number> {
    @Nullable
    public Number convert(Entity entity) {
        if (entity instanceof Display) {
            Display display = (Display)entity;
            return display.getTeleportDuration();
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.ADD, Changer.ChangeMode.SET, Changer.ChangeMode.REMOVE -> (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
            case Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            default -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Object object;
        int newVal = 0;
        if (delta != null && (object = delta[0]) instanceof Number) {
            Number number = (Number)object;
            newVal = number.intValue();
        }
        for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
            if (!(entity instanceof Display)) continue;
            Display display = (Display)entity;
            int oldVal = display.getTeleportDuration();
            int duration = switch (mode) {
                case Changer.ChangeMode.ADD -> oldVal + newVal;
                case Changer.ChangeMode.REMOVE -> oldVal - newVal;
                case Changer.ChangeMode.SET -> newVal;
                default -> 0;
            };
            duration = MathUtil.clamp(duration, 0, 59);
            display.setTeleportDuration(duration);
        }
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "display teleport duration";
    }

    static {
        if (Skript.methodExists(Display.class, (String)"getTeleportDuration", (Class[])new Class[0])) {
            ExprDisplayTeleportDuration.register(ExprDisplayTeleportDuration.class, Number.class, (String)"[display] teleport[ation] duration", (String)"entities");
        }
    }
}

