/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Name(value="DisplayEntity - Rotation")
@Description(value={"Represents the transformation left/right rotation of a Display Entity.", "See [**Display Entity Data**](https://minecraft.wiki/w/Display#Entity_data) on McWiki for more details."})
@Examples(value={"set display left rotation of {_display} to quaternion(0,1,1,0)", "set display right rotation of {_display} to quaternion(1,0,0,5)", "set display right rotation of {_display} to axisAngle(5,1,0,0)"})
@Since(value={"2.8.0"})
public class ExprDisplayRotation
extends SimplePropertyExpression<Entity, Quaternionf> {
    private boolean right;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.right = parseResult.hasTag("r");
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Quaternionf convert(Entity entity) {
        if (!(entity instanceof Display)) {
            return null;
        }
        Display display = (Display)entity;
        Transformation transformation = display.getTransformation();
        return this.right ? transformation.getRightRotation() : transformation.getLeftRotation();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Quaternionf.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Entity[] entityArray;
        if (delta != null && (entityArray = delta[0]) instanceof Quaternionf) {
            Quaternionf vec4f = (Quaternionf)entityArray;
            for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
                if (!(entity instanceof Display)) continue;
                Display display = (Display)entity;
                Transformation oldTransform = display.getTransformation();
                Vector3f translation = oldTransform.getTranslation();
                Vector3f scale = oldTransform.getScale();
                Quaternionf leftRotation = this.right ? oldTransform.getLeftRotation() : vec4f;
                Quaternionf rightRotation = this.right ? vec4f : oldTransform.getRightRotation();
                Transformation newTransform = new Transformation(translation, leftRotation, scale, rightRotation);
                display.setTransformation(newTransform);
            }
        }
    }

    @NotNull
    public Class<? extends Quaternionf> getReturnType() {
        return Quaternionf.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "display " + (this.right ? "right" : "left") + " rotation";
    }

    static {
        ExprDisplayRotation.register(ExprDisplayRotation.class, Quaternionf.class, (String)"display (left|r:right) rotation", (String)"entities");
    }
}

