/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="DisplayEntity - Interpolation Start/Duration")
@Description(value={"Represents the interpolation start and duration times for a Display Entity.", "NOTE: Due to how these work, you will need to use integers as ticks instead of time spans.", "See [**Display Entity Data**](https://minecraft.wiki/w/Display#Entity_data) on McWiki for more details."})
@Examples(value={"set display interpolation start of {_display} to -1", "set display interpolation delay of {_display} to 200"})
@Since(value={"2.8.0"})
public class ExprDisplayInterpolation
extends SimplePropertyExpression<Entity, Number> {
    private boolean duration;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.duration = parseResult.hasTag("d");
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Number convert(Entity entity) {
        if (!(entity instanceof Display)) {
            return null;
        }
        Display display = (Display)entity;
        return (long)(this.duration ? display.getInterpolationDuration() : display.getInterpolationDelay());
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Object object;
        if (delta != null && (object = delta[0]) instanceof Number) {
            Number num = (Number)object;
            int changeValue = num.intValue();
            for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
                if (!(entity instanceof Display)) continue;
                Display display = (Display)entity;
                if (this.duration) {
                    display.setInterpolationDuration(changeValue);
                    continue;
                }
                display.setInterpolationDelay(changeValue);
            }
        }
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "interpolation " + (this.duration ? "duration" : "start");
    }

    static {
        ExprDisplayInterpolation.register(ExprDisplayInterpolation.class, Number.class, (String)"[display] interpolation ((start|delay)|d:duration)", (String)"entities");
    }
}

