/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.display.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="DisplayEntity - Billboard")
@Description(value={"Represents the billboard of a Display Entity.", "See [**Display Entity Data**](https://minecraft.wiki/w/Display#Entity_data) on McWiki for more details."})
@Examples(value={"set display billboard of {_display} to horizontal"})
@Since(value={"2.8.0"})
public class ExprDisplayBillboard
extends SimplePropertyExpression<Entity, Display.Billboard> {
    @Nullable
    public Display.Billboard convert(Entity entity) {
        if (entity instanceof Display) {
            Display display = (Display)entity;
            return display.getBillboard();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Display.Billboard.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Entity[] entityArray;
        if (delta != null && (entityArray = delta[0]) instanceof Display.Billboard) {
            Display.Billboard billboard = (Display.Billboard)entityArray;
            for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
                if (!(entity instanceof Display)) continue;
                Display display = (Display)entity;
                display.setBillboard(billboard);
            }
        }
    }

    @NotNull
    public Class<? extends Display.Billboard> getReturnType() {
        return Display.Billboard.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "display billboard";
    }

    static {
        ExprDisplayBillboard.register(ExprDisplayBillboard.class, Display.Billboard.class, (String)"display billboard", (String)"entities");
    }
}

