/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.damagesource.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.damage.DamageSource;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="DamageSource - Event Value")
@Description(value={"Get the damage source of a damage/death event."})
@Examples(value={"on damage of player:", "\tif damage type of damage source = arrow:", "\t\tbroadcast \"OUCHIE\"", "\tif causing entity of damage source is a chicken:", "\t\tbroadcast \"YOU JERK\""})
@Since(value={"3.3.0"})
public class ExprDamageSourceEvent
extends SimpleExpression<DamageSource> {
    private static final boolean DEATH_EVENT_HAS_DAMAGE_SOURCE = Skript.methodExists(EntityDeathEvent.class, (String)"getDamageSource", (Class[])new Class[0]);

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (DEATH_EVENT_HAS_DAMAGE_SOURCE) {
            if (ParserInstance.get().isCurrentEvent(new Class[]{EntityDamageEvent.class, EntityDeathEvent.class})) {
                return true;
            }
            Skript.error((String)"'damage source' can only be used in a death/damage event");
            return false;
        }
        if (ParserInstance.get().isCurrentEvent(EntityDamageEvent.class)) {
            return true;
        }
        Skript.error((String)"'damage source' can only be used in a damage event");
        return false;
    }

    protected DamageSource @Nullable [] get(Event event) {
        if (event instanceof EntityDamageEvent) {
            EntityDamageEvent entityDamageEvent = (EntityDamageEvent)event;
            return new DamageSource[]{entityDamageEvent.getDamageSource()};
        }
        if (DEATH_EVENT_HAS_DAMAGE_SOURCE && event instanceof EntityDeathEvent) {
            EntityDeathEvent entityDeathEvent = (EntityDeathEvent)event;
            return new DamageSource[]{entityDeathEvent.getDamageSource()};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends DamageSource> getReturnType() {
        return DamageSource.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "damage source";
    }

    static {
        Skript.registerExpression(ExprDamageSourceEvent.class, DamageSource.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] damage source"});
    }
}

