/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.damagesource.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import org.bukkit.Location;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="DamageSource - Create")
@Description(value={"Create a new damage source which includes a damage type and some optional values.", "Optional Values:", "`caused by %entity%` = The entity that caused the damage.", "`directly by %entity%` = The entity that directly inflicted the damage.", "`at %location%` = The source of the damage."})
@Examples(value={"set {_source} to damage source from arrow directly by (random element of all entities)", "set {_source} to damage source of dragon breath", "set {_source} to damage source of magic", "set {_source} to damage source of mob_attack_no_aggro caused by target entity of player", "damage player by 100 with {_source}"})
@Since(value={"3.3.0"})
public class ExprDamageSourceCreate
extends SimpleExpression<DamageSource> {
    private Expression<DamageType> damageType;
    private Expression<Entity> causingEntity;
    private Expression<Entity> directEntity;
    private Expression<Location> damageLocation;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.damageType = exprs[0];
        this.causingEntity = exprs[1];
        this.directEntity = exprs[2];
        this.damageLocation = exprs[3];
        return true;
    }

    protected DamageSource @Nullable [] get(Event event) {
        DamageType damageType = (DamageType)this.damageType.getSingle(event);
        if (damageType == null) {
            this.error("Damage type is not set");
            return null;
        }
        Entity causing = this.causingEntity != null ? (Entity)this.causingEntity.getSingle(event) : null;
        Entity direct = this.directEntity != null ? (Entity)this.directEntity.getSingle(event) : null;
        Location damageLocation = this.damageLocation != null ? (Location)this.damageLocation.getSingle(event) : null;
        DamageSource.Builder builder = DamageSource.builder((DamageType)damageType);
        if (direct != null) {
            builder.withDirectEntity(direct);
        }
        if (causing != null) {
            builder.withCausingEntity(causing);
            if (direct == null) {
                builder.withDirectEntity(causing);
            }
        }
        if (damageLocation != null) {
            builder.withDamageLocation(damageLocation);
        }
        return new DamageSource[]{builder.build()};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends DamageSource> getReturnType() {
        return DamageSource.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String type = this.damageType.toString(e, d);
        String cause = this.causingEntity != null ? " caused by " + this.causingEntity.toString(e, d) : "";
        String direct = this.directEntity != null ? " directly by " + this.directEntity.toString(e, d) : "";
        String loc = this.damageLocation != null ? " at " + this.damageLocation.toString(e, d) : "";
        return "damage source of " + type + cause + direct + loc;
    }

    static {
        Skript.registerExpression(ExprDamageSourceCreate.class, DamageSource.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[[a] new] damage source (of|from) %damagetype% [caused by %-entity%] [directly (by|from) %-entity%] [at %-location%]"});
    }
}

