/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bound.types;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.yggdrasil.Fields;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.bound.Bound;
import com.shanebeestudios.skbee.api.bound.BoundConfig;
import java.io.StreamCorruptedException;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkriptTypes {
    private static String getLoc(@NotNull Location location) {
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        return String.format("location(%.2f, %.2f, %.2f)", x, y, z);
    }

    static {
        Classes.registerClass((ClassInfo)new ClassInfo(Bound.class, "bound").user(new String[]{"bound"}).name("Bound").description(new String[]{"Represents a 3D bounding box between 2 points"}).defaultExpression((DefaultExpression)new EventValueExpression(Bound.class)).since("1.0.0").parser((Parser)new Parser<Bound>(){

            public boolean canParse(ParseContext context) {
                return false;
            }

            @NotNull
            public String toString(Bound bound, int flags) {
                String greater = SkriptTypes.getLoc(bound.getGreaterCorner());
                String lesser = SkriptTypes.getLoc(bound.getLesserCorner());
                String world = bound.getWorldName();
                return String.format((bound.isTemporary() ? "temporary bound" : "bound") + " '%s' between %s and %s in world \"%s\"", bound.getId(), lesser, greater, world);
            }

            @NotNull
            public String toVariableNameString(Bound bound) {
                return String.format("bound:%s", bound.getId());
            }

            public String getVariableNamePattern() {
                return "bound:.+";
            }
        }).serializer((Serializer)new Serializer<Bound>(){

            @NotNull
            public Fields serialize(Bound bound) {
                Fields fields = new Fields();
                fields.putObject("boundID", (Object)bound.getId());
                return fields;
            }

            public void deserialize(Bound bound, Fields fields) {
                assert (false);
            }

            @Nullable
            public Bound deserialize(String s) {
                return null;
            }

            protected Bound deserialize(Fields fields) throws StreamCorruptedException {
                String boundID = (String)fields.getObject("boundID", String.class);
                Bound bound = SkBee.getPlugin().getBoundConfig().getBoundFromID(boundID);
                if (bound == null) {
                    throw new StreamCorruptedException("Unable to find bound with id '" + boundID + "'");
                }
                return bound;
            }

            public boolean mustSyncDeserialization() {
                return true;
            }

            protected boolean canBeInstantiated() {
                return false;
            }
        }).changer((Changer)new Changer<Bound>(){

            @Nullable
            public @Nullable Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
                if (mode == Changer.ChangeMode.DELETE) {
                    return (Class[])CollectionUtils.array((Object[])new Class[0]);
                }
                return null;
            }

            public void change(Bound[] bounds, @Nullable Object[] delta, Changer.ChangeMode mode) {
                if (mode == Changer.ChangeMode.DELETE) {
                    BoundConfig boundConfig = SkBee.getPlugin().getBoundConfig();
                    for (Bound bound : bounds) {
                        boundConfig.removeBound(bound);
                    }
                }
            }
        }));
    }
}

