/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bound.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.bound.Bound;
import com.shanebeestudios.skbee.api.bound.BoundConfig;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Bound - Bounds at Location")
@Description(value={"Get a list of non-temporary, temporary, or all bounds bounds/ids at a location."})
@Examples(value={"set {_temporaryBounds::*} to temporary bounds at player", "set {_nonTemporaryBounds::*} to nontemporary bounds at {_loc}", "loop all bounds at {locations::*}:", "\tbroadcast loop-bound"})
@Since(value={"1.0.0, 2.15.0 (temporary/non-temporary)"})
public class ExprBoundsAtLocation
extends SimpleExpression<Object> {
    private static final BoundConfig boundConfig;
    private Expression<Location> locations;
    private boolean ID;
    private Kleenean boundType;

    public boolean init(Expression<?>[] exprs, int pattern, Kleenean kleenean, SkriptParser.ParseResult parse) {
        this.locations = exprs[0];
        this.ID = parse.hasTag("id");
        this.boundType = Kleenean.get((int)parse.mark);
        return true;
    }

    protected Object[] get(Event event) {
        ArrayList<Bound> bounds = new ArrayList<Bound>();
        ArrayList<String> ids = new ArrayList<String>();
        for (Location location : (Location[])this.locations.getArray(event)) {
            for (Bound bound : boundConfig.getBoundsAt(location)) {
                if (bounds.contains(bound) || bounds.contains(bound.getId()) || this.boundType == Kleenean.FALSE && !bound.isTemporary() || this.boundType == Kleenean.TRUE && bound.isTemporary()) continue;
                if (this.ID) {
                    ids.add(bound.getId());
                    continue;
                }
                bounds.add(bound);
            }
        }
        return this.ID ? ids.toArray(new String[0]) : bounds.toArray(new Bound[0]);
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<?> getReturnType() {
        if (this.ID) {
            return String.class;
        }
        return Bound.class;
    }

    @NotNull
    public String toString(Event event, boolean debug) {
        String ID = this.ID ? " ids" : "s";
        String atLocation = " at " + this.locations.toString(event, debug);
        return (switch (this.boundType) {
            default -> throw new IncompatibleClassChangeError();
            case Kleenean.TRUE -> "all non-temporary bound";
            case Kleenean.FALSE -> "all temporary bound";
            case Kleenean.UNKNOWN -> "all bound";
        }) + ID + atLocation;
    }

    static {
        Skript.registerExpression(ExprBoundsAtLocation.class, Object.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[all [[of] the]|the] [-1:temporary|1:non[-| ]temporary] bound[s] [:id[s]] at %locations%"});
        boundConfig = SkBee.getPlugin().getBoundConfig();
    }
}

