/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bound.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.bound.Bound;
import com.shanebeestudios.skbee.api.bound.BoundConfig;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Bound - Locations")
@Description(value={"Get/modify the locations of a bound.", "Greater will always equal the higher south-east corner. ", "Lesser will always equal the lower north-west corner.", "You can set the two corners of the bound to new values.", "You can also add/subtract vectors to/from the corners."})
@Examples(value={"set {_center} to bound center of bound with id \"spawn-bound\"", "set block at bound greater corner of {_bound} to pink wool", "set bound lesser corner of {_bound} to location of player", "set bound greater corner of bound with id \"ma_bound\" to {_loc}", "add vector(5,5,5) to bound greater corner of {_bound}", "subtract vector(0,10,0) from bound greater corner of {_bound}"})
@Since(value={"3.5.9"})
public class ExprBoundLocations
extends SimplePropertyExpression<Bound, Location> {
    private static final BoundConfig BOUND_CONFIG = SkBee.getPlugin().getBoundConfig();
    private int type;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.type = parseResult.mark;
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Location convert(Bound bound) {
        return switch (this.type) {
            case 1 -> bound.getGreaterCorner();
            case 2 -> bound.getLesserCorner();
            default -> bound.getCenter();
        };
    }

    public Class<?> @Nullable [] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (this.type == 0) {
            Skript.error((String)"You cannot modify the center of a bound. You can modify the lesser/greater corners.");
            return null;
        }
        return switch (mode) {
            case Changer.ChangeMode.SET -> (Class[])CollectionUtils.array((Object[])new Class[]{Location.class});
            case Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE -> (Class[])CollectionUtils.array((Object[])new Class[]{Vector.class});
            default -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        block11: {
            block10: {
                if (delta == null) {
                    return;
                }
                if (mode != Changer.ChangeMode.SET) break block10;
                Bound[] boundArray = delta[0];
                if (!(boundArray instanceof Location)) break block11;
                Location location = (Location)boundArray;
                for (Bound bound : (Bound[])this.getExpr().getArray(event)) {
                    Location less = this.type == 2 ? location : bound.getLesserCorner();
                    Location great = this.type == 1 ? location : bound.getGreaterCorner();
                    bound.resize(less, great);
                    BOUND_CONFIG.saveBound(bound, true);
                }
                break block11;
            }
            Bound[] boundArray = delta[0];
            if (boundArray instanceof Vector) {
                Vector vector = (Vector)boundArray;
                for (Bound bound : (Bound[])this.getExpr().getArray(event)) {
                    Location less = bound.getLesserCorner();
                    Location great = bound.getGreaterCorner().subtract(1.0, 1.0, 1.0);
                    if (mode == Changer.ChangeMode.ADD) {
                        if (this.type == 1) {
                            great.add(vector);
                        } else {
                            less.add(vector);
                        }
                    } else if (this.type == 1) {
                        great.subtract(vector);
                    } else {
                        less.subtract(vector);
                    }
                    bound.resize(less, great);
                    BOUND_CONFIG.saveBound(bound, true);
                }
            }
        }
    }

    @NotNull
    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "bound " + (switch (this.type) {
            case 1 -> "greater corner";
            case 2 -> "lesser corner";
            default -> "center";
        });
    }

    static {
        ExprBoundLocations.register(ExprBoundLocations.class, Location.class, (String)"bound (0:center|(1:greater|2:lesser) corner)", (String)"bounds");
    }
}

