/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bound.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.bound.Bound;
import com.shanebeestudios.skbee.api.bound.BoundConfig;
import com.shanebeestudios.skbee.api.util.Util;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Bound - ID")
@Description(value={"Get/set the id of a bound. When setting the ID of a bound, if another bound has that ID, this will fail with an error in console.", "You cannot set the IDs of multiple bounds at once."})
@Examples(value={"set {_id} to id of first element of bounds at player", "loop all bounds at player:", "\tset id of loop-bound to \"%player%-%id of loop-bound%\"", "set {_id} to id of event-bound", "send \"You entered bound '%id of loop-bound%'\""})
@Since(value={"1.15.0"})
public class ExprBoundID
extends SimplePropertyExpression<Bound, String> {
    private static final BoundConfig BOUND_CONFIG = SkBee.getPlugin().getBoundConfig();

    @Nullable
    public String convert(Bound bound) {
        return bound.getId();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (!this.getExpr().isSingle()) {
            Skript.error((String)"Can't set the id of multiple bounds at once!");
            return null;
        }
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta == null || !this.getExpr().isSingle()) {
            return;
        }
        String id = (String)delta[0];
        Bound bound = (Bound)this.getExpr().getSingle(event);
        if (bound == null) {
            return;
        }
        if (BOUND_CONFIG.boundExists(id)) {
            Util.skriptError("Bound with ID '%s' already exists, you can not rename bound with id '%s' to that.", id, bound.getId());
            return;
        }
        BOUND_CONFIG.removeBound(bound);
        bound.setId(id);
        BOUND_CONFIG.saveBound(bound, false);
    }

    @NotNull
    protected String getPropertyName() {
        return "bound id";
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        ExprBoundID.register(ExprBoundID.class, String.class, (String)"[bound] id", (String)"bounds");
    }
}

