/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.bound.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.bound.Bound;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Bound - Intersects")
@Description(value={"Check if a bound intersects with another bound or a potential bound at 2 locations."})
@Examples(value={"if {_bound} intersects with {_loc1} and {_loc2}:", "if {_bound} intersects with {_bound2}:", "if {_bound} doesn't intersect with {_loc1} and {_loc2}:", "if {_bound} doesn't intersect with {_bound2}:"})
@Since(value={"2.3.0"})
public class CondBoundIntersects
extends Condition {
    private Expression<Bound> bound1;
    private Expression<Bound> bound2;
    private Expression<Location> loc1;
    private Expression<Location> loc2;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.bound1 = exprs[0];
        if (matchedPattern == 0 || matchedPattern == 2) {
            this.loc1 = exprs[1];
            this.loc2 = exprs[2];
        } else {
            this.bound2 = exprs[1];
        }
        this.setNegated(matchedPattern > 1);
        return true;
    }

    public boolean check(Event event) {
        if (this.bound2 != null) {
            return this.bound1.check(event, bound -> this.bound2.check(event, bound::overlaps), this.isNegated());
        }
        if (this.loc1 != null && this.loc2 != null) {
            Location loc1 = (Location)this.loc1.getSingle(event);
            Location loc2 = (Location)this.loc2.getSingle(event);
            if (loc1 == null || loc2 == null) {
                return false;
            }
            return this.bound1.check(event, bound -> bound.overlaps(loc1, loc2), this.isNegated());
        }
        return false;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        Object possible;
        String intersect;
        String bound = this.bound1.toString(e, d);
        String string = intersect = this.isNegated() ? " doesn't intersect with " : " intersects with ";
        if (this.bound2 != null) {
            possible = this.bound2.toString(e, d);
        } else {
            String l1 = this.loc1.toString(e, d);
            String l2 = this.loc2.toString(e, d);
            possible = l1 + " and " + l2;
        }
        return bound + intersect + (String)possible;
    }

    static {
        Skript.registerCondition(CondBoundIntersects.class, (String[])new String[]{"%bound% (intersects with|overlaps) %location% and %location%", "%bound% (intersects with|overlaps) %bound%", "%bound% doesn't (intersect with|overlap) %location% and %location%", "%bound% doesn't (intersect with|overlap) %bound%"});
    }
}

