/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.advancement.type;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.yggdrasil.Fields;
import com.shanebeestudios.skbee.api.util.SkriptUtils;
import com.shanebeestudios.skbee.api.util.Util;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Types {
    static {
        if (Classes.getExactClassInfo(Advancement.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(Advancement.class, "advancement").user(new String[]{"advancements?"}).name("Advancement").description(new String[]{"Represents an advancement. These CAN be parsed, see examples."}).examples(new String[]{"set {_a} to \"minecraft:nether/use_lodestone\" parsed as advancement"}).since("1.17.0").parser((Parser)new Parser<Advancement>(){

                public boolean canParse(ParseContext context) {
                    return context != ParseContext.DEFAULT;
                }

                @Nullable
                public Advancement parse(String string, ParseContext context) {
                    NamespacedKey namespacedKey = Util.getNamespacedKey(string, false);
                    if (namespacedKey != null) {
                        return Bukkit.getAdvancement((NamespacedKey)namespacedKey);
                    }
                    return null;
                }

                @NotNull
                public String toString(Advancement advancement, int i) {
                    return advancement.getKey().toString();
                }

                @NotNull
                public String toVariableNameString(Advancement advancement) {
                    return "advancement:" + this.toString(advancement, 0);
                }
            }).serializer((Serializer)new Serializer<Advancement>(){

                @NotNull
                public Fields serialize(Advancement advancement) throws NotSerializableException {
                    Fields fields = new Fields();
                    fields.putObject("advancement", (Object)advancement.getKey().toString());
                    return fields;
                }

                public void deserialize(Advancement advancement, Fields fields) {
                }

                protected Advancement deserialize(Fields fields) throws StreamCorruptedException {
                    NamespacedKey namespacedKey;
                    String string = (String)fields.getObject("advancement", String.class);
                    if (string != null && (namespacedKey = NamespacedKey.fromString((String)string)) != null) {
                        return Bukkit.getAdvancement((NamespacedKey)namespacedKey);
                    }
                    return null;
                }

                public boolean mustSyncDeserialization() {
                    return false;
                }

                protected boolean canBeInstantiated() {
                    return false;
                }
            }));
        } else {
            Util.logLoading("It looks like another addon registered 'advancement' already.", new Object[0]);
            Util.logLoading("You may have to use their advancements in SkBee's 'advancement' elements.", new Object[0]);
        }
        if (Classes.getExactClassInfo(AdvancementProgress.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(AdvancementProgress.class, "advancementpro").user(new String[]{"advancement ?progress(es)?"}).name("Advancement Progress").description(new String[]{"Represents the advancement progress of a player.", "You will see `%advancementpro%` in the docs, this is due to a silly issue with Skript", "where I couldn't use `progress` in expressions."}).parser(SkriptUtils.getDefaultParser()).since("1.17.0"));
        } else {
            Util.logLoading("It looks like another addon registered 'advancementpro' already.", new Object[0]);
            Util.logLoading("You may have to use their advancement progresses in SkBee's 'advancement' elements.", new Object[0]);
        }
    }
}

