/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.advancement.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.advancement.Advancement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Advancement - Criteria")
@Description(value={"Get a list of the criteria for an advancement."})
@Examples(value={"set {_c::*} to criteria of {_advancement}"})
@Since(value={"1.17.0"})
public class ExprAdvancementCriteria
extends SimpleExpression<String> {
    private Expression<Advancement> advancement;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.advancement = exprs[0];
        return true;
    }

    @Nullable
    protected String[] get(Event event) {
        ArrayList criteria = new ArrayList();
        for (Advancement advancement : (Advancement[])this.advancement.getArray(event)) {
            criteria.addAll(advancement.getCriteria());
        }
        return criteria.toArray(new String[0]);
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "criteria of " + this.advancement.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprAdvancementCriteria.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"criteria of %advancements%", "%advancement%'[s] criteria"});
    }
}

