/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.advancement.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Advancement - Progress Criteria")
@Description(value={"Award or revoke criteria of an advancement progress."})
@Examples(value={"TODO"})
@Since(value={"1.17.0"})
public class EffAdvancementCriteriaAward
extends Effect {
    private boolean award;
    private Expression<String> criteria;
    private Expression<AdvancementProgress> progress;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.award = parseResult.mark == 0;
        this.criteria = exprs[0];
        this.progress = exprs[1];
        return true;
    }

    protected void execute(Event event) {
        String criteria = (String)this.criteria.getSingle(event);
        if (criteria == null) {
            return;
        }
        for (AdvancementProgress progress : (AdvancementProgress[])this.progress.getArray(event)) {
            if (this.award) {
                progress.awardCriteria(criteria);
                continue;
            }
            progress.revokeCriteria(criteria);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String award = this.award ? "award" : "revoke";
        return award + " criteria " + this.criteria.toString(e, d) + " of " + this.progress.toString(e, d);
    }

    static {
        Skript.registerEffect(EffAdvancementCriteriaAward.class, (String[])new String[]{"(award|1:revoke) criteria %string% of %advancementpros%"});
    }
}

