/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.advancement.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Advancement - Done")
@Description(value={"Check if the advancement progress is done."})
@Examples(value={"if advancement progress of {_advancement} of player is done:"})
@Since(value={"1.17.0"})
public class CondAdvancementDone
extends Condition {
    private Expression<AdvancementProgress> progress;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.setNegated(i == 2);
        this.progress = exprs[0];
        return true;
    }

    public boolean check(Event event) {
        return this.progress.check(event, AdvancementProgress::isDone, this.isNegated());
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return PropertyCondition.toString((Condition)this, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.BE, (Event)e, (boolean)d, this.progress, (String)"done");
    }

    static {
        Skript.registerCondition(CondAdvancementDone.class, (String[])new String[]{"%advancementpro% is done", "%advancementpro% (isn't|is not) done"});
    }
}

