/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.virtualfurnace.api.builder;

import com.shanebeestudios.skbee.api.virtualfurnace.api.builder.ItemBuilder;
import java.util.function.Consumer;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;

public class PotionItemBuilder
extends ItemBuilder {
    private PotionMeta potionMeta;

    public PotionItemBuilder() {
        super(Material.POTION, 1);
    }

    public PotionItemBuilder(@NotNull Material material) {
        super(material);
        if (this.isNotPotion(material)) {
            this.itemStack.setType(Material.POTION);
        }
    }

    public PotionItemBuilder(@NotNull Material material, int amount) {
        super(material, amount);
        if (this.isNotPotion(material)) {
            this.itemStack.setType(Material.POTION);
        }
    }

    public PotionItemBuilder(@NotNull Material material, @NotNull Consumer<ItemMeta> meta) {
        super(material, meta);
        if (this.isNotPotion(material)) {
            this.itemStack.setType(Material.POTION);
        }
    }

    public PotionItemBuilder(@NotNull Material material, int amount, @NotNull Consumer<ItemMeta> meta) {
        super(material, amount, meta);
        if (this.isNotPotion(material)) {
            this.itemStack.setType(Material.POTION);
        }
    }

    public PotionItemBuilder addPotion(@NotNull PotionEffect potionEffect) {
        if (this.itemMeta instanceof PotionMeta) {
            ((PotionMeta)this.itemMeta).addCustomEffect(potionEffect, false);
        }
        return this;
    }

    public PotionItemBuilder basePotion(@NotNull PotionType type, boolean extended, boolean upgraded) {
        if (this.itemMeta instanceof PotionMeta) {
            ((PotionMeta)this.itemMeta).setBasePotionData(new PotionData(type, extended, upgraded));
        }
        return this;
    }

    public PotionItemBuilder addPotion(@NotNull PotionEffectType type, int duration) {
        if (this.itemMeta instanceof PotionMeta) {
            PotionEffect potionEffect = new PotionEffect(type, duration, 0, false, true, true);
            ((PotionMeta)this.itemMeta).addCustomEffect(potionEffect, false);
        }
        return this;
    }

    public PotionItemBuilder addPotion(@NotNull PotionEffectType type, int duration, int amplifier) {
        if (this.itemMeta instanceof PotionMeta) {
            PotionEffect potionEffect = new PotionEffect(type, duration, amplifier, false, true, true);
            ((PotionMeta)this.itemMeta).addCustomEffect(potionEffect, false);
        }
        return this;
    }

    public PotionItemBuilder addPotion(@NotNull PotionEffectType type, int duration, int amplifier, boolean ambient) {
        if (this.itemMeta instanceof PotionMeta) {
            PotionEffect potionEffect = new PotionEffect(type, duration, amplifier, ambient, true, true);
            ((PotionMeta)this.itemMeta).addCustomEffect(potionEffect, false);
        }
        return this;
    }

    public PotionItemBuilder addPotion(@NotNull PotionEffectType type, int duration, int amplifier, boolean ambient, boolean particles) {
        if (this.itemMeta instanceof PotionMeta) {
            PotionEffect potionEffect = new PotionEffect(type, duration, amplifier, ambient, particles, true);
            ((PotionMeta)this.itemMeta).addCustomEffect(potionEffect, false);
        }
        return this;
    }

    public PotionItemBuilder addPotion(@NotNull PotionEffectType type, int duration, int amplifier, boolean ambient, boolean particles, boolean icon) {
        if (this.itemMeta instanceof PotionMeta) {
            PotionEffect potionEffect = new PotionEffect(type, duration, amplifier, ambient, particles, icon);
            ((PotionMeta)this.itemMeta).addCustomEffect(potionEffect, false);
        }
        return this;
    }

    public PotionItemBuilder color(@NotNull Color color) {
        if (this.itemMeta instanceof PotionMeta) {
            ((PotionMeta)this.itemMeta).setColor(color);
        }
        return this;
    }

    private boolean isNotPotion(@NotNull Material material) {
        switch (material) {
            case POTION: 
            case LINGERING_POTION: 
            case SPLASH_POTION: {
                return false;
            }
        }
        return true;
    }
}

