/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.util;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import com.shanebeestudios.skbee.api.reflection.ReflectionConstants;
import com.shanebeestudios.skbee.api.reflection.ReflectionUtils;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import java.util.function.Predicate;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityUtils {
    private static final boolean HAS_NO_PHYSICS = Skript.methodExists(Entity.class, (String)"hasNoPhysics", (Class[])new Class[0]);
    public static final boolean HAS_TRANSIENT = Skript.methodExists(AttributeInstance.class, (String)"addTransientModifier", (Class[])new Class[]{AttributeModifier.class});
    private static final Class<?> ENTITY_NMS_CLASS = ReflectionUtils.getNMSClass("net.minecraft.world.entity.Entity");

    public static void setNoPhysics(@NotNull Entity entity, boolean clip) {
        if (HAS_NO_PHYSICS) {
            entity.setNoPhysics(clip);
        }
        if (ENTITY_NMS_CLASS == null) {
            return;
        }
        Object nmsEntity = ReflectionUtils.getNMSEntity(entity);
        if (nmsEntity == null) {
            return;
        }
        ReflectionUtils.setField(ReflectionConstants.ENTITY_NO_PHYSICS_FIELD, ENTITY_NMS_CLASS, nmsEntity, clip);
    }

    public static boolean getNoPhysics(@NotNull Entity entity) {
        if (HAS_NO_PHYSICS) {
            return entity.hasNoPhysics();
        }
        if (ENTITY_NMS_CLASS == null) {
            return false;
        }
        Object nmsEntity = ReflectionUtils.getNMSEntity(entity);
        if (nmsEntity == null) {
            return false;
        }
        return Boolean.parseBoolean(ReflectionUtils.getField(ReflectionConstants.ENTITY_NO_PHYSICS_FIELD, ENTITY_NMS_CLASS, nmsEntity).toString());
    }

    public static Predicate<Entity> filter(@Nullable LivingEntity livingEntity, @Nullable Object[] ignored) {
        return filterEntity -> {
            if (filterEntity == livingEntity) {
                return false;
            }
            if (ignored != null) {
                for (Object object : ignored) {
                    EntityData ed;
                    Entity entity;
                    if (!(object instanceof Entity ? filterEntity == (entity = (Entity)object) : object instanceof EntityData && (ed = (EntityData)object).isInstance(filterEntity))) continue;
                    return false;
                }
            }
            return true;
        };
    }

    public static boolean hasAttributeModifier(LivingEntity entity, Attribute attribute, AttributeModifier modifier) {
        AttributeInstance attributeInstance = entity.getAttribute(attribute);
        if (attributeInstance == null) {
            return false;
        }
        for (AttributeModifier attributeInstanceModifier : attributeInstance.getModifiers()) {
            if (ItemUtils.HAS_KEY && attributeInstanceModifier.getKey().equals((Object)modifier.getKey())) {
                return true;
            }
            if (!attributeInstanceModifier.getName().equalsIgnoreCase(modifier.getName())) continue;
            return true;
        }
        return false;
    }
}

