/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.reflection;

import ch.njol.skript.Skript;
import com.shanebeestudios.skbee.SkBee;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class ReflectionUtils {
    private static final String CRAFTBUKKIT_PACKAGE = Bukkit.getServer().getClass().getPackage().getName();
    private static final boolean MAPPED_SERVER = Skript.classExists((String)"net.minecraft.world.level.Level");

    @Nullable
    public static Class<?> getOBCClass(String obcClassString) {
        String name = CRAFTBUKKIT_PACKAGE + "." + obcClassString;
        return ReflectionUtils.getClass(name);
    }

    @Nullable
    public static Class<?> getNMSClass(String nmsClass) {
        return ReflectionUtils.getClass(nmsClass);
    }

    @Nullable
    public static Class<?> getNMSClass(String mojangMapping, String bukkitMapping) {
        if (!MAPPED_SERVER) {
            String split = ((String)mojangMapping).substring(0, ((String)mojangMapping).lastIndexOf("."));
            mojangMapping = split + "." + bukkitMapping;
        }
        return ReflectionUtils.getClass((String)mojangMapping);
    }

    @Nullable
    private static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            if (SkBee.isDebug()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    @Nullable
    public static Object getNMSEntity(Entity entity) {
        try {
            Method getHandle = entity.getClass().getMethod("getHandle", new Class[0]);
            return getHandle.invoke((Object)entity, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            if (SkBee.isDebug()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    @Nullable
    public static Object getField(String field, Class<?> clazz, Object object) {
        try {
            Field f = clazz.getDeclaredField(field);
            f.setAccessible(true);
            return f.get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            if (SkBee.isDebug()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public static void setField(String field, Class<?> clazz, Object object, Object toSet) {
        block2: {
            try {
                Field f = clazz.getDeclaredField(field);
                f.setAccessible(true);
                f.set(object, toSet);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException ex) {
                if (!SkBee.isDebug()) break block2;
                ex.printStackTrace();
            }
        }
    }

    public static void setField(String field, Object object, Object toSet) {
        block2: {
            try {
                Field f = object.getClass().getDeclaredField(field);
                f.setAccessible(true);
                f.set(object, toSet);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException ex) {
                if (!SkBee.isDebug()) break block2;
                ex.printStackTrace();
            }
        }
    }

    public static boolean methodExists(String className, String methodName) {
        if (Skript.classExists((String)className)) {
            try {
                Class<?> clazz = Class.forName(className);
                if (Skript.methodExists(clazz, (String)methodName, (Class[])new Class[0])) {
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }
}

