/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.property;

import ch.njol.skript.classes.Changer;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public abstract class Property<F, T> {
    String name;
    private String[] description;
    private String since;
    private String[] examples;
    private final Class<F> propertyHolder;
    private final Class<T> propertyValueType;
    private Boolean canSet;
    private Boolean canAdd;
    private Boolean canRemove;
    private Boolean canDelete;
    private Boolean canReset;

    public Property(Class<F> propertyHolder, Class<T> propertyValueType) {
        this.propertyHolder = propertyHolder;
        this.propertyValueType = propertyValueType;
        this.getChangeModes();
    }

    public Property<F, T> description(String ... description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return String.join((CharSequence)"    \n", this.description);
    }

    public Property<F, T> since(String since) {
        this.since = since;
        return this;
    }

    public String getSince() {
        return this.since;
    }

    public Property<F, T> examples(String ... examples) {
        this.examples = examples;
        return this;
    }

    public String[] getExamples() {
        return this.examples;
    }

    public String getName() {
        return this.name;
    }

    public Class<F> getPropertyHolder() {
        return this.propertyHolder;
    }

    public Class<T> getReturnType() {
        return this.propertyValueType;
    }

    public boolean isArray() {
        return this.propertyValueType.isArray();
    }

    public abstract T get(F var1);

    public void set(F holder, T value) {
    }

    public void add(F holder, T value) {
    }

    public void remove(F holder, T value) {
    }

    public void delete(F holder) {
    }

    public void reset(F holder) {
    }

    public String getChangeModes() {
        ArrayList<String> modes = new ArrayList<String>();
        for (Changer.ChangeMode mode : Changer.ChangeMode.values()) {
            if (mode == Changer.ChangeMode.SET) {
                if (this.canSet == null) {
                    try {
                        this.canSet = this.getClass().getDeclaredMethod("set", Object.class, Object.class) != null;
                    }
                    catch (NoSuchMethodException ignore) {
                        this.canSet = false;
                    }
                }
                if (!this.canSet.booleanValue()) continue;
                modes.add("set");
                continue;
            }
            if (mode == Changer.ChangeMode.ADD) {
                if (this.canAdd == null) {
                    try {
                        this.canAdd = this.getClass().getDeclaredMethod("add", Object.class, Object.class) != null;
                    }
                    catch (NoSuchMethodException ignore) {
                        this.canAdd = false;
                    }
                }
                if (!this.canAdd.booleanValue()) continue;
                modes.add("add");
                continue;
            }
            if (mode == Changer.ChangeMode.REMOVE) {
                if (this.canRemove == null) {
                    try {
                        this.canRemove = this.getClass().getDeclaredMethod("remove", Object.class, Object.class) != null;
                    }
                    catch (NoSuchMethodException ignore) {
                        this.canRemove = false;
                    }
                }
                if (!this.canRemove.booleanValue()) continue;
                modes.add("remove");
                continue;
            }
            if (mode == Changer.ChangeMode.DELETE) {
                if (this.canDelete == null) {
                    try {
                        this.canDelete = this.getClass().getDeclaredMethod("delete", Object.class) != null;
                    }
                    catch (NoSuchMethodException ignore) {
                        this.canDelete = false;
                    }
                }
                if (!this.canDelete.booleanValue()) continue;
                modes.add("delete/clear");
                continue;
            }
            if (mode != Changer.ChangeMode.RESET) continue;
            if (this.canReset == null) {
                try {
                    this.canReset = this.getClass().getDeclaredMethod("reset", Object.class) != null;
                }
                catch (NoSuchMethodException ignore) {
                    this.canReset = false;
                }
            }
            if (!this.canReset.booleanValue()) continue;
            modes.add("reset");
        }
        if (modes.isEmpty()) {
            return "*Cannot be changed*";
        }
        return String.join((CharSequence)", ", modes);
    }

    public Class<T> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET && this.canSet.booleanValue()) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{this.propertyValueType});
        }
        if (mode == Changer.ChangeMode.ADD && this.canAdd.booleanValue()) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{this.propertyValueType});
        }
        if (mode == Changer.ChangeMode.REMOVE && this.canRemove.booleanValue()) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{this.propertyValueType});
        }
        if (mode == Changer.ChangeMode.DELETE && this.canDelete.booleanValue()) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        if (mode == Changer.ChangeMode.RESET && this.canReset.booleanValue()) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }
}

