/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.particle;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.util.Color;
import ch.njol.util.StringUtils;
import com.shanebeestudios.skbee.api.reflection.ReflectionUtils;
import com.shanebeestudios.skbee.api.util.Util;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParticleUtil {
    private static final Map<String, Particle> PARTICLES = new HashMap<String, Particle>();
    private static final Map<Particle, String> PARTICLE_NAMES = new HashMap<Particle, String>();
    private static final boolean HAS_PLAYER_FORCE = Skript.methodExists(Player.class, (String)"spawnParticle", (Class[])new Class[]{Particle.class, Location.class, Integer.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Object.class, Boolean.TYPE});
    public static final boolean HAS_TRAIL = Skript.classExists((String)"org.bukkit.Particle$Trail");

    private ParticleUtil() {
    }

    public static String getNamesAsString() {
        ArrayList names = new ArrayList();
        PARTICLES.forEach((s, particle) -> {
            Object name = s;
            if (particle.getDataType() != Void.class) {
                name = (String)name + " [" + ParticleUtil.getDataType(particle) + "]";
            }
            names.add(name);
        });
        Collections.sort(names);
        return StringUtils.join(names, (String)", ");
    }

    public static String getName(Particle particle) {
        return PARTICLE_NAMES.get(particle);
    }

    public static List<Particle> getAvailableParticles() {
        return new ArrayList<Particle>(PARTICLES.values());
    }

    @Nullable
    public static Particle parse(String key) {
        if (PARTICLES.containsKey(key)) {
            return PARTICLES.get(key);
        }
        return null;
    }

    private static String getDataType(Particle particle) {
        Class dataType = particle.getDataType();
        if (dataType == ItemStack.class) {
            return "itemtype";
        }
        if (dataType == Particle.DustOptions.class) {
            return "dust-option";
        }
        if (dataType == BlockData.class) {
            return "blockdata/itemtype";
        }
        if (dataType == Particle.DustTransition.class) {
            return "dust-transition";
        }
        if (dataType == Vibration.class) {
            return "vibration";
        }
        if (dataType == Integer.class) {
            return "number(int)";
        }
        if (dataType == Float.class) {
            return "number(float)";
        }
        if (dataType == org.bukkit.Color.class) {
            return "color/bukkitcolor";
        }
        if (HAS_TRAIL && dataType == Particle.Trail.class) {
            return "trail";
        }
        Util.debug("Missing particle data type: '&e" + dataType.getName() + "&7'", new Object[0]);
        return "UNKNOWN";
    }

    public static void spawnParticle(@NotNull Particle particle, @Nullable Player[] players, @NotNull Location location, int count, Object data, Vector offset, double extra, boolean force) {
        Object particleData = ParticleUtil.getData(particle, data);
        if (particle.getDataType() != Void.class && particleData == null) {
            return;
        }
        double x = offset.getX();
        double y = offset.getY();
        double z = offset.getZ();
        if (players == null) {
            World world = location.getWorld();
            if (world == null) {
                return;
            }
            world.spawnParticle(particle, location, count, x, y, z, extra, particleData, force);
        } else {
            for (Player player : players) {
                assert (player != null);
                if (HAS_PLAYER_FORCE) {
                    player.spawnParticle(particle, location, count, x, y, z, extra, particleData, force);
                    continue;
                }
                player.spawnParticle(particle, location, count, x, y, z, extra, particleData);
            }
        }
    }

    @Nullable
    private static Object getData(Particle particle, Object data) {
        Class dataType = particle.getDataType();
        if (dataType == Void.class) {
            return null;
        }
        if (dataType == Float.class && data instanceof Number) {
            Number number = (Number)data;
            return Float.valueOf(number.floatValue());
        }
        if (dataType == Integer.class && data instanceof Number) {
            Number number = (Number)data;
            return number.intValue();
        }
        if (dataType == ItemStack.class && data instanceof ItemType) {
            ItemType itemType = (ItemType)data;
            return itemType.getRandom();
        }
        if (dataType == Particle.DustOptions.class && data instanceof Particle.DustOptions) {
            return data;
        }
        if (dataType == Particle.DustTransition.class && data instanceof Particle.DustTransition) {
            return data;
        }
        if (dataType == Vibration.class && data instanceof Vibration) {
            return data;
        }
        if (dataType == org.bukkit.Color.class && data instanceof Color) {
            Color skriptColor = (Color)data;
            return skriptColor.asBukkitColor();
        }
        if (dataType == org.bukkit.Color.class && data instanceof org.bukkit.Color) {
            return data;
        }
        if (dataType == BlockData.class) {
            ItemType itemType;
            Material material;
            if (data instanceof BlockData) {
                return data;
            }
            if (data instanceof ItemType && (material = (itemType = (ItemType)data).getMaterial()).isBlock()) {
                return material.createBlockData();
            }
        } else if (HAS_TRAIL && dataType == Particle.Trail.class && data instanceof Particle.Trail) {
            return data;
        }
        return null;
    }

    static {
        if (Skript.methodExists(Particle.class, (String)"getKey", (Class[])new Class[0])) {
            Registry.PARTICLE_TYPE.forEach(particle -> {
                String key = particle.getKey().getKey();
                PARTICLES.put(key, (Particle)particle);
                PARTICLE_NAMES.put((Particle)particle, key);
            });
        } else {
            Class<?> cbParticle = ReflectionUtils.getOBCClass("CraftParticle");
            try {
                assert (cbParticle != null);
                Field bukkitParticleField = cbParticle.getDeclaredField("bukkit");
                bukkitParticleField.setAccessible(true);
                Field mcKeyField = cbParticle.getDeclaredField("minecraftKey");
                mcKeyField.setAccessible(true);
                for (Object enumConstant : cbParticle.getEnumConstants()) {
                    String mcKey = mcKeyField.get(enumConstant).toString().replace("minecraft:", "");
                    Particle bukkitParticle = (Particle)bukkitParticleField.get(enumConstant);
                    if (bukkitParticle.toString().contains("LEGACY")) continue;
                    PARTICLES.put(mcKey, bukkitParticle);
                    PARTICLE_NAMES.put(bukkitParticle, mcKey);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }
}

