/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.nbt;

import com.shanebeestudios.skbee.api.nbt.NBTApi;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.nbt.NBTContainer;
import com.shanebeestudios.skbee.api.nbt.NBTCustom;
import com.shanebeestudios.skbee.api.nbt.NBTItem;
import com.shanebeestudios.skbee.api.nbt.NBTReflection;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class NBTCustomItemStack
extends NBTContainer
implements NBTCustom {
    private final ItemStack originalItemStack;
    private final boolean isFull;

    public NBTCustomItemStack(ItemStack itemStack, boolean isVanilla, boolean isFull) {
        super(NBTCustomItemStack.getInitialContainer(itemStack, isVanilla, isFull).getCompound());
        this.originalItemStack = itemStack;
        this.isFull = isFull;
    }

    private static NBTCompound getInitialContainer(ItemStack itemStack, boolean isVanilla, boolean isFull) {
        NBTCompound nbtContainer = isVanilla ? NBTReflection.getVanillaNBT(itemStack) : NBTItem.convertItemtoNBT(itemStack);
        if (nbtContainer == null) {
            nbtContainer = new NBTContainer();
        }
        NBTContainer clone = new NBTContainer();
        clone.mergeCompound(NBTCustomItemStack.getContainer(nbtContainer, isFull));
        return clone;
    }

    private static NBTCompound getContainer(NBTCompound itemContainer, boolean isFull) {
        if (isFull) {
            return itemContainer;
        }
        return itemContainer.getOrCreateCompound(NBTApi.TAG_NAME);
    }

    @Override
    protected void saveCompound() {
        super.saveCompound();
        if (this.isFull) {
            return;
        }
        NBTContainer originalItemContainer = NBTItem.convertItemtoNBT(this.originalItemStack.clone());
        NBTCompound components = NBTCustomItemStack.getContainer(originalItemContainer, false);
        components.clearNBT();
        components.mergeCompound(this);
        ItemStack itemStack = NBTItem.convertNBTtoItem(originalItemContainer);
        if (itemStack == null) {
            return;
        }
        this.originalItemStack.setItemMeta(itemStack.getItemMeta());
    }

    public ItemStack getItem() {
        return this.originalItemStack.clone();
    }

    @Override
    public void deleteCustomNBT() {
    }

    @Override
    @NotNull
    public NBTCompound getCopy() {
        NBTContainer nbtContainer = new NBTContainer();
        nbtContainer.mergeCompound(this);
        return nbtContainer;
    }

    @Override
    @NotNull
    public NBTCompound getCustomNBT() {
        if (NBTApi.HAS_ITEM_COMPONENTS) {
            return this.getOrCreateCompound("minecraft:custom_data");
        }
        return this;
    }
}

