/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.listener;

import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.nbt.NBTChunk;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.config.Config;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class NBTListener {
    public NBTListener(SkBee plugin) {
        Config config = plugin.getPluginConfig();
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (config.NBT_EVENTS_BREAK_BLOCK) {
            pluginManager.registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR)
                private void onBlockBreak(BlockBreakEvent event) {
                    if (event.isCancelled()) {
                        return;
                    }
                    NBTListener.this.breakBlock(event.getBlock());
                }
            }, (Plugin)plugin);
        }
        if (config.NBT_EVENTS_ENTITY_CHANGE_BLOCK) {
            pluginManager.registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR)
                private void onEntityBreakBlock(EntityChangeBlockEvent event) {
                    if (event.isCancelled()) {
                        return;
                    }
                    switch (event.getEntity().getType()) {
                        case ENDERMAN: 
                        case ZOMBIE: 
                        case SILVERFISH: 
                        case RABBIT: 
                        case RAVAGER: 
                        case WITHER: {
                            NBTListener.this.breakBlock(event.getBlock());
                        }
                    }
                }
            }, (Plugin)plugin);
        }
        if (config.NBT_EVENTS_BLOCK_EXPLODE) {
            pluginManager.registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR)
                private void onExplode(BlockExplodeEvent event) {
                    if (event.isCancelled()) {
                        return;
                    }
                    event.blockList().forEach(NBTListener.this::breakBlock);
                }
            }, (Plugin)plugin);
        }
        if (config.NBT_EVENTS_ENTITY_EXPLODE) {
            pluginManager.registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR)
                private void onEntityExplode(EntityExplodeEvent event) {
                    if (event.isCancelled()) {
                        return;
                    }
                    event.blockList().forEach(NBTListener.this::breakBlock);
                }
            }, (Plugin)plugin);
        }
        if (config.NBT_EVENTS_PISTON_EXTEND) {
            pluginManager.registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR)
                private void onPistonPush(BlockPistonExtendEvent event) {
                    if (event.isCancelled()) {
                        return;
                    }
                    Block piston = event.getBlock();
                    BlockState blockState = piston.getState();
                    if (event.isSticky()) {
                        return;
                    }
                    if (blockState instanceof TileState) {
                        return;
                    }
                    event.getBlocks().forEach(NBTListener.this::breakBlock);
                }
            }, (Plugin)plugin);
        }
    }

    private void breakBlock(Block block) {
        if (block.getState() instanceof TileState) {
            return;
        }
        NBTCompound chunkContainer = new NBTChunk(block.getChunk()).getPersistentDataContainer();
        if (chunkContainer.hasTag("blocks")) {
            NBTCompound blocksContainer = chunkContainer.getOrCreateCompound("blocks");
            this.removeNBT(blocksContainer, block);
            BlockData blockData = block.getBlockData();
            if (blockData instanceof Bisected) {
                Bisected bisected = (Bisected)blockData;
                BlockFace face = bisected.getHalf() == Bisected.Half.BOTTOM ? BlockFace.UP : BlockFace.DOWN;
                this.removeNBT(blocksContainer, block.getRelative(face));
            }
            if (blocksContainer.getKeys().isEmpty()) {
                chunkContainer.removeKey("blocks");
            }
        }
    }

    private void removeNBT(NBTCompound blocksContainer, Block block) {
        String blockKey = String.format("%s_%s_%s", block.getX(), block.getY(), block.getZ());
        if (blocksContainer.hasTag(blockKey)) {
            blocksContainer.removeKey(blockKey);
        }
    }
}

