/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.command;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptUpdater;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.property.PropertyPrinter;
import com.shanebeestudios.skbee.api.util.Util;
import com.shanebeestudios.skbee.config.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkBeeInfo
implements TabExecutor {
    private static final List<String> commands = List.of("info", "debug");
    private static final List<String> debugs = List.of("enable", "disable");
    private final PluginDescriptionFile desc;
    private final Config config;

    public SkBeeInfo(SkBee plugin) {
        this.desc = plugin.getDescription();
        this.config = plugin.getPluginConfig();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String @NotNull [] args) {
        if (args.length == 0) {
            StringJoiner joiner = new StringJoiner("/");
            commands.forEach(joiner::add);
            Util.sendColMsg(sender, "Usage: /skbee <" + String.valueOf(joiner) + ">", new Object[0]);
        } else if (args[0].equalsIgnoreCase("info")) {
            Util.sendColMsg(sender, "&7--- [&bSkBee Loading Info&7] ---", new Object[0]);
            Util.getDebugs().forEach(debug -> Util.sendColMsg(sender, "- &7" + debug, new Object[0]));
            Util.sendColMsg(sender, "&7--- [&bServer Info&7] ---", new Object[0]);
            Util.sendColMsg(sender, "&7Server Version: &b" + Bukkit.getName() + " " + Bukkit.getVersion(), new Object[0]);
            SkriptUpdater updater = Skript.getInstance().getUpdater();
            Object flavor = "&cunknown-flavor";
            if (updater != null) {
                flavor = updater.getCurrentRelease().flavor;
                flavor = ((String)flavor).equalsIgnoreCase("skriptlang-github") ? "&a" + (String)flavor : "&e" + (String)flavor;
            }
            Util.sendColMsg(sender, "&7Skript Version: &b%s &7(%s&7)", Skript.getVersion(), flavor);
            Util.sendColMsg(sender, "&7Skript Addons:", new Object[0]);
            Skript.getAddons().forEach(addon -> {
                String name = addon.getName();
                if (!name.contains("SkBee")) {
                    Util.sendColMsg(sender, "&7- &b" + name + " v" + addon.plugin.getDescription().getVersion(), new Object[0]);
                }
            });
            Util.sendColMsg(sender, "&7SkBee Version: &b" + this.desc.getVersion(), new Object[0]);
            Util.sendColMsg(sender, "&7SkBee Website: &b" + this.desc.getWebsite(), new Object[0]);
        } else if (args[0].equalsIgnoreCase("debug")) {
            if (args.length > 1 && args[1].equalsIgnoreCase("enable")) {
                Util.sendColMsg(sender, "Debug mode is now &aenabled!", new Object[0]);
                this.config.settings_debug = true;
            } else if (args.length > 1 && args[1].equalsIgnoreCase("disable")) {
                Util.sendColMsg(sender, "Debug mode is now &cdisabled!", new Object[0]);
                this.config.settings_debug = false;
            } else {
                String enabled = this.config.settings_debug ? "&aenabled" : "&cdisabled";
                Util.sendColMsg(sender, "Debug mode is currently %s", enabled);
            }
        } else if (args[0].equalsIgnoreCase("properties")) {
            PropertyPrinter.printAll();
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String @NotNull [] args) {
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], commands, new ArrayList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("debug")) {
            return (List)StringUtil.copyPartialMatches((String)args[1], debugs, new ArrayList());
        }
        return null;
    }
}

