/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.bound;

import com.google.common.base.Preconditions;
import com.shanebeestudios.skbee.api.bound.Bound;
import com.shanebeestudios.skbee.api.bound.BoundRegion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoundWorld {
    private static final long SHIFT_VALUE = 8L;
    @NotNull
    private final World world;
    private final Map<Long, BoundRegion> regions = new HashMap<Long, BoundRegion>();

    public BoundWorld(@NotNull World world) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World cannot be null");
        this.world = world;
    }

    @Nullable
    public BoundRegion getRegionAtLocation(Location location) {
        long id = this.getIdFromLocation(location);
        return this.regions.get(id);
    }

    @NotNull
    public BoundRegion getOrCreateRegionAtLocation(Location location) {
        long id = this.getIdFromLocation(location);
        BoundRegion boundRegion = this.regions.get(id);
        if (boundRegion == null) {
            boundRegion = new BoundRegion(id);
            this.regions.put(id, boundRegion);
        }
        return boundRegion;
    }

    private long getIdFromLocation(Location location) {
        long x = location.getBlockX() >> 8;
        long z = location.getBlockZ() >> 8;
        return x & 0xFFFFFFFFL | (z & 0xFFFFFFFFL) << 32;
    }

    public void addBoundToRegion(Bound bound) {
        for (Location loc : this.getLocationList(bound)) {
            BoundRegion region = this.getOrCreateRegionAtLocation(loc);
            region.addBound(bound);
        }
    }

    public void removeBoundFromRegion(Bound bound) {
        for (Location loc : this.getLocationList(bound)) {
            BoundRegion region = this.getRegionAtLocation(loc);
            if (region == null) continue;
            region.removeBound(bound);
            if (region.size() != 0) continue;
            this.regions.remove(region.getId());
        }
    }

    private List<Location> getLocationList(Bound bound) {
        ArrayList<Location> locations = new ArrayList<Location>();
        BoundingBox box = bound.getBoundingBox();
        int minBlockX = box.getMin().getBlockX();
        int minBlockZ = box.getMin().getBlockZ();
        int maxBlockX = box.getMax().getBlockX();
        int maxBlockZ = box.getMax().getBlockZ();
        int shift = 256;
        for (int x = minBlockX; x <= maxBlockX + shift; x += shift) {
            for (int z = minBlockZ; z <= maxBlockZ + shift; z += shift) {
                locations.add(new Location(this.world, (double)Math.min(x, maxBlockX), 0.0, (double)Math.min(z, maxBlockZ)));
            }
        }
        return locations;
    }

    public List<Bound> getBoundsAtLocation(Location location) {
        BoundRegion region = this.getOrCreateRegionAtLocation(location);
        return region.getBounds();
    }
}

