/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.api.bound;

import ch.njol.skript.Skript;
import ch.njol.skript.test.runner.TestMode;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.bound.Bound;
import com.shanebeestudios.skbee.api.bound.BoundPostponing;
import com.shanebeestudios.skbee.api.bound.BoundWorld;
import com.shanebeestudios.skbee.api.region.TaskUtils;
import com.shanebeestudios.skbee.api.region.scheduler.Scheduler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoundConfig
implements Listener {
    private final File boundFile;
    private final FileConfiguration boundConfig;
    private final BoundPostponing boundPostponing;
    private final Map<String, Bound> boundsMap = new HashMap<String, Bound>();
    private final Map<World, BoundWorld> boundWorldMap = new HashMap<World, BoundWorld>();
    private final Map<String, Bound> scheduledToSave = new HashMap<String, Bound>();
    private final List<String> scheduledToRemove = new ArrayList<String>();

    public BoundConfig(SkBee plugin) {
        this.boundPostponing = new BoundPostponing(this);
        this.boundFile = new File(plugin.getDataFolder(), "bounds.yml");
        if (!this.boundFile.exists()) {
            plugin.saveResource("bounds.yml", false);
        }
        this.boundConfig = YamlConfiguration.loadConfiguration((File)this.boundFile);
        ConfigurationSection section = this.boundConfig.getConfigurationSection("bounds");
        if (section != null) {
            for (String key : section.getKeys(true)) {
                Object object = section.get(key);
                if (!(object instanceof Bound)) continue;
                Bound bound = (Bound)object;
                if (bound.getWorld() == null) {
                    this.boundPostponing.postponeLoading(bound);
                    continue;
                }
                this.addBoundToRegionAndMap(bound);
            }
        }
        this.boundPostponing.print();
        if (!TestMode.ENABLED) {
            this.startSaveTimer();
        }
    }

    private void startSaveTimer() {
        Scheduler<?> globalScheduler = TaskUtils.getGlobalScheduler();
        globalScheduler.runTaskTimer(() -> {
            if (this.scheduledToSave.isEmpty() && this.scheduledToRemove.isEmpty()) {
                return;
            }
            this.scheduledToRemove.forEach(id -> this.boundConfig.set("bounds." + id, null));
            this.scheduledToRemove.clear();
            this.scheduledToSave.forEach((id, bound) -> this.boundConfig.set("bounds." + id, bound));
            this.scheduledToSave.clear();
            globalScheduler.runTaskAsync(this::saveConfig);
        }, 6000L, 6000L);
    }

    public void saveBound(Bound bound, boolean updateRegions) {
        if (updateRegions) {
            this.removeBoundFromRegion(bound);
            this.addBoundToRegionAndMap(bound);
        }
        if (!bound.isTemporary()) {
            this.scheduledToSave.put(bound.getId(), bound);
        }
    }

    public void removeBound(Bound bound) {
        this.removeBoundFromRegionAndMap(bound);
        if (!bound.isTemporary()) {
            this.scheduledToRemove.add(bound.getId());
        }
    }

    public boolean boundExists(String id) {
        return this.boundsMap.containsKey(id);
    }

    @Nullable
    public Bound getBoundFromID(String id) {
        if (this.boundsMap.containsKey(id)) {
            return this.boundsMap.get(id);
        }
        return null;
    }

    public void saveAllBoundsOnShutdown() {
        if (!this.scheduledToRemove.isEmpty()) {
            this.scheduledToRemove.forEach(id -> this.boundConfig.set("bounds." + id, null));
            this.scheduledToRemove.clear();
        }
        for (Bound bound : this.boundsMap.values()) {
            if (bound.isTemporary()) continue;
            this.boundConfig.set("bounds." + bound.getId(), (Object)bound);
        }
        this.saveConfig();
    }

    private void saveConfig() {
        try {
            this.boundConfig.save(this.boundFile);
        }
        catch (IOException e) {
            throw Skript.exception((Throwable)e, (String[])new String[0]);
        }
    }

    public Collection<Bound> getBounds() {
        return this.boundsMap.values();
    }

    public Collection<Bound> getBoundsIn(World world) {
        return this.boundsMap.values().stream().filter(bound -> world.equals((Object)bound.getWorld())).toList();
    }

    public Collection<Bound> getBoundsAt(Location location) {
        return this.getBoundsInRegion(location).stream().filter(bound -> bound.isInRegion(location)).toList();
    }

    @NotNull
    public BoundWorld getOrCreateBoundWorld(World world) {
        BoundWorld boundWorld = this.boundWorldMap.get(world);
        if (boundWorld == null) {
            boundWorld = new BoundWorld(world);
            this.boundWorldMap.put(world, boundWorld);
        }
        return boundWorld;
    }

    @Nullable
    public BoundWorld getBoundWorld(World world) {
        return this.boundWorldMap.get(world);
    }

    public List<Bound> getBoundsInRegion(Location location) {
        BoundWorld boundWorld = this.getOrCreateBoundWorld(location.getWorld());
        return boundWorld.getBoundsAtLocation(location);
    }

    public void addBoundToRegionAndMap(Bound bound) {
        BoundWorld boundWorld = this.getOrCreateBoundWorld(bound.getWorld());
        boundWorld.addBoundToRegion(bound);
        this.boundsMap.put(bound.getId(), bound);
    }

    public void removeBoundFromRegion(Bound bound) {
        BoundWorld boundWorld = this.getBoundWorld(bound.getWorld());
        if (boundWorld != null) {
            boundWorld.removeBoundFromRegion(bound);
        }
    }

    public void removeBoundFromRegionAndMap(Bound bound) {
        this.removeBoundFromRegion(bound);
        this.boundsMap.remove(bound.getId());
    }
}

