/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.reflectionremapper.proxy;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.reflectionremapper.ReflectionRemapper;
import xyz.jpenilla.reflectionremapper.internal.util.Util;
import xyz.jpenilla.reflectionremapper.proxy.annotation.ConstructorInvoker;
import xyz.jpenilla.reflectionremapper.proxy.annotation.FieldGetter;
import xyz.jpenilla.reflectionremapper.proxy.annotation.FieldSetter;
import xyz.jpenilla.reflectionremapper.proxy.annotation.MethodName;
import xyz.jpenilla.reflectionremapper.proxy.annotation.Static;
import xyz.jpenilla.reflectionremapper.proxy.annotation.Type;

final class ReflectionProxyInvocationHandler<I>
implements InvocationHandler {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final Class<I> interfaceClass;
    private final Class<?> proxiedClass;
    private final Map<Method, MethodHandle> methods = new HashMap<Method, MethodHandle>();
    private final Map<Method, MethodHandle> getters = new HashMap<Method, MethodHandle>();
    private final Map<Method, MethodHandle> setters = new HashMap<Method, MethodHandle>();
    private final Map<Method, MethodHandle> staticGetters = new HashMap<Method, MethodHandle>();
    private final Map<Method, MethodHandle> staticSetters = new HashMap<Method, MethodHandle>();
    private final Map<Method, MethodHandle> defaultMethods = new ConcurrentHashMap<Method, MethodHandle>();

    ReflectionProxyInvocationHandler(Class<I> interfaceClass, Class<?> proxiedClass, ReflectionRemapper reflectionRemapper) {
        this.interfaceClass = interfaceClass;
        this.proxiedClass = proxiedClass;
        this.scanInterface(reflectionRemapper);
    }

    @Override
    public @Nullable Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (ReflectionProxyInvocationHandler.isEqualsMethod(method)) {
            return proxy == args[0];
        }
        if (ReflectionProxyInvocationHandler.isHashCodeMethod(method)) {
            return 0;
        }
        if (ReflectionProxyInvocationHandler.isToStringMethod(method)) {
            return String.format("ReflectionProxy[interface=%s, implementation=%s, proxies=%s]", this.interfaceClass.getTypeName(), proxy.getClass().getTypeName(), this.proxiedClass.getTypeName());
        }
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if (method.isDefault()) {
            return this.handleDefaultMethod(proxy, method, args);
        }
        @Nullable MethodHandle methodHandle = this.methods.get(method);
        if (methodHandle != null) {
            if (args.length == 0) {
                return methodHandle.invokeExact();
            }
            return methodHandle.invokeExact(args);
        }
        @Nullable MethodHandle getter = this.getters.get(method);
        if (getter != null) {
            return getter.invokeExact(args[0]);
        }
        @Nullable MethodHandle setter = this.setters.get(method);
        if (setter != null) {
            return setter.invokeExact(args[0], args[1]);
        }
        @Nullable MethodHandle staticGetter = this.staticGetters.get(method);
        if (staticGetter != null) {
            return staticGetter.invokeExact();
        }
        @Nullable MethodHandle staticSetter = this.staticSetters.get(method);
        if (staticSetter != null) {
            return staticSetter.invokeExact(args[0]);
        }
        throw new IllegalStateException();
    }

    private @Nullable Object handleDefaultMethod(Object proxy, Method method, Object[] args) throws Throwable {
        MethodHandle handle = this.defaultMethods.computeIfAbsent(method, m -> ReflectionProxyInvocationHandler.adapt(Util.sneakyThrows(() -> Util.handleForDefaultMethod(this.interfaceClass, m)).bindTo(proxy)));
        if (args.length == 0) {
            return handle.invokeExact();
        }
        return handle.invokeExact(args);
    }

    private void scanInterface(ReflectionRemapper reflectionRemapper) {
        this.scanInterface(reflectionRemapper::remapClassOrArrayName, fieldName -> reflectionRemapper.remapFieldName(this.proxiedClass, (String)fieldName), (methodName, parameters) -> reflectionRemapper.remapMethodName(this.proxiedClass, (String)methodName, (Class<?>)parameters));
    }

    private void scanInterface(UnaryOperator<String> classMapper, UnaryOperator<String> fieldMapper, BiFunction<String, Class<?>[], String> methodMapper) {
        for (Method method : this.interfaceClass.getDeclaredMethods()) {
            MethodHandle handle;
            boolean hasStaticAnnotation;
            boolean constructorInvoker;
            if (ReflectionProxyInvocationHandler.isEqualsMethod(method) || ReflectionProxyInvocationHandler.isHashCodeMethod(method) || ReflectionProxyInvocationHandler.isToStringMethod(method) || Util.isSynthetic(method.getModifiers()) || method.isDefault()) continue;
            boolean bl = constructorInvoker = method.getDeclaredAnnotation(ConstructorInvoker.class) != null;
            if (constructorInvoker) {
                this.methods.put(method, ReflectionProxyInvocationHandler.adapt(Util.sneakyThrows(() -> LOOKUP.unreflectConstructor(this.findProxiedConstructor(method, classMapper)))));
                continue;
            }
            @Nullable FieldGetter getterAnnotation = method.getDeclaredAnnotation(FieldGetter.class);
            @Nullable FieldSetter setterAnnotation = method.getDeclaredAnnotation(FieldSetter.class);
            if (getterAnnotation != null && setterAnnotation != null) {
                throw new IllegalArgumentException("Method " + method.getName() + " in " + this.interfaceClass.getTypeName() + " is annotated with @FieldGetter and @FieldSetter, don't know which to use.");
            }
            boolean bl2 = hasStaticAnnotation = method.getDeclaredAnnotation(Static.class) != null;
            if (getterAnnotation != null) {
                handle = Util.sneakyThrows(() -> LOOKUP.unreflectGetter(this.findProxiedField(getterAnnotation.value(), fieldMapper)));
                if (hasStaticAnnotation) {
                    ReflectionProxyInvocationHandler.checkParameterCount(method, this.interfaceClass, 0, "Static @FieldGetters should have no parameters.");
                    this.staticGetters.put(method, handle.asType(MethodType.methodType(Object.class)));
                    continue;
                }
                ReflectionProxyInvocationHandler.checkParameterCount(method, this.interfaceClass, 1, "Non-static @FieldGetters should have one parameter.");
                this.getters.put(method, handle.asType(MethodType.methodType(Object.class, Object.class)));
                continue;
            }
            if (setterAnnotation != null) {
                handle = Util.sneakyThrows(() -> LOOKUP.unreflectSetter(this.findProxiedField(setterAnnotation.value(), fieldMapper)));
                if (hasStaticAnnotation) {
                    ReflectionProxyInvocationHandler.checkParameterCount(method, this.interfaceClass, 1, "Static @FieldSetters should have one parameter.");
                    this.staticSetters.put(method, handle.asType(MethodType.methodType(Object.class, Object.class)));
                    continue;
                }
                ReflectionProxyInvocationHandler.checkParameterCount(method, this.interfaceClass, 2, "Non-static @FieldSetters should have two parameters.");
                this.setters.put(method, handle.asType(MethodType.methodType(Object.class, Object.class, Object.class)));
                continue;
            }
            if (!hasStaticAnnotation && method.getParameterCount() < 1) {
                throw new IllegalArgumentException("Non-static method invokers should have at least one parameter. Method " + method.getName() + " in " + this.interfaceClass.getTypeName() + " has " + method.getParameterCount());
            }
            this.methods.put(method, ReflectionProxyInvocationHandler.adapt(Util.sneakyThrows(() -> LOOKUP.unreflect(this.findProxiedMethod(method, classMapper, methodMapper)))));
        }
    }

    private static MethodHandle adapt(MethodHandle handle) {
        if (handle.type().parameterCount() == 0) {
            return handle.asType(MethodType.methodType(Object.class));
        }
        return handle.asSpreader(Object[].class, handle.type().parameterCount()).asType(MethodType.methodType(Object.class, Object[].class));
    }

    private static void checkParameterCount(Method method, Class<?> holder, int expected, String message) {
        if (method.getParameterCount() != expected) {
            throw new IllegalArgumentException(String.format("Unexpected amount of parameters for method %s in %s, got %d while expecting %d. %s", method.getName(), holder.getTypeName(), method.getParameterCount(), expected, message));
        }
    }

    private static boolean isToStringMethod(Method method) {
        return method.getName().equals("toString") && method.getParameterCount() == 0 && method.getReturnType() == String.class;
    }

    private static boolean isHashCodeMethod(Method method) {
        return method.getName().equals("hashCode") && method.getParameterCount() == 0 && method.getReturnType() == Integer.TYPE;
    }

    private static boolean isEqualsMethod(Method method) {
        return method.getName().equals("equals") && method.getParameterCount() == 1 && method.getReturnType() == Boolean.TYPE;
    }

    private Field findProxiedField(String fieldName, UnaryOperator<String> fieldMapper) {
        Field field;
        try {
            field = this.proxiedClass.getDeclaredField((String)fieldMapper.apply(fieldName));
        }
        catch (NoSuchFieldException e2) {
            throw new IllegalArgumentException("Could not find field '" + fieldName + "' in " + this.proxiedClass.getTypeName(), e2);
        }
        try {
            field.setAccessible(true);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not set access for field '" + fieldName + "' in " + this.proxiedClass.getTypeName(), ex);
        }
        return field;
    }

    private Constructor<?> findProxiedConstructor(Method method, UnaryOperator<String> classMapper) {
        Constructor<?> constructor;
        Class[] actualParams = (Class[])Arrays.stream(method.getParameters()).map(p -> this.resolveParameterTypeClass((Parameter)p, classMapper)).toArray(Class[]::new);
        try {
            constructor = this.proxiedClass.getDeclaredConstructor(actualParams);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("Could not find constructor of " + this.proxiedClass.getTypeName() + " with parameter types " + Arrays.toString(method.getParameterTypes()), ex);
        }
        try {
            constructor.setAccessible(true);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not set access for proxy method target constructor of " + this.proxiedClass.getTypeName() + " with parameter types " + Arrays.toString(method.getParameterTypes()), ex);
        }
        return constructor;
    }

    private Method findProxiedMethod(Method method, UnaryOperator<String> classMapper, BiFunction<String, Class<?>[], String> methodMapper) {
        Method proxiedMethod;
        boolean hasStaticAnnotation = method.getDeclaredAnnotation(Static.class) != null;
        Class[] actualParams = hasStaticAnnotation ? (Class[])Arrays.stream(method.getParameters()).map(p -> this.resolveParameterTypeClass((Parameter)p, classMapper)).toArray(Class[]::new) : (Class[])Arrays.stream(method.getParameters()).skip(1L).map(p -> this.resolveParameterTypeClass((Parameter)p, classMapper)).toArray(Class[]::new);
        @Nullable MethodName methodAnnotation = method.getDeclaredAnnotation(MethodName.class);
        String methodName = methodAnnotation == null ? method.getName() : methodAnnotation.value();
        try {
            proxiedMethod = this.proxiedClass.getDeclaredMethod(methodMapper.apply(methodName, actualParams), actualParams);
        }
        catch (NoSuchMethodException e2) {
            throw new IllegalArgumentException("Could not find proxy method target method: " + this.proxiedClass.getTypeName() + " " + methodName);
        }
        try {
            proxiedMethod.setAccessible(true);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not set access for proxy method target method: " + this.proxiedClass.getTypeName() + " " + methodName, ex);
        }
        return proxiedMethod;
    }

    private Class<?> resolveParameterTypeClass(Parameter parameter, UnaryOperator<String> classMapper) {
        Class<?> namedClass;
        @Nullable Type typeAnnotation = parameter.getDeclaredAnnotation(Type.class);
        if (typeAnnotation == null) {
            return parameter.getType();
        }
        if (typeAnnotation.value() == Object.class && typeAnnotation.className().isEmpty()) {
            throw new IllegalArgumentException("@Type annotation must either have value() or className() set.");
        }
        if (typeAnnotation.value() != Object.class) {
            return Util.findProxiedClass(typeAnnotation.value(), classMapper);
        }
        try {
            namedClass = Class.forName((String)classMapper.apply(typeAnnotation.className()));
        }
        catch (ClassNotFoundException e2) {
            throw new IllegalArgumentException("Class " + typeAnnotation.className() + " specified in @Type annotation not found.", e2);
        }
        return namedClass;
    }
}

