/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.format;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.MappingFlag;
import net.fabricmc.mappingio.MappingWriter;

public final class EnigmaWriter
implements MappingWriter {
    private static final Set<MappingFlag> flags = EnumSet.of(MappingFlag.NEEDS_UNIQUENESS, MappingFlag.NEEDS_SRC_FIELD_DESC, MappingFlag.NEEDS_SRC_METHOD_DESC);
    private static final String toEscape = "\\\n\r\u0000\t";
    private static final String escaped = "\\nr0t";
    private final Path dir;
    private Writer writer;
    private String writerClass;
    private String writtenClass;
    private int indent;
    private String srcClassName;
    private String dstName;
    private String desc;

    public EnigmaWriter(final Path dir, boolean deleteExistingFiles) throws IOException {
        this.dir = dir.toAbsolutePath().normalize();
        if (deleteExistingFiles && Files.exists(dir, new LinkOption[0])) {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().endsWith(".mapping")) {
                        Files.delete(file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path file, IOException exc) throws IOException {
                    try {
                        if (!dir.equals(file)) {
                            Files.delete(file);
                        }
                    }
                    catch (DirectoryNotEmptyException directoryNotEmptyException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
            this.writerClass = null;
        }
    }

    @Override
    public Set<MappingFlag> getFlags() {
        return flags;
    }

    @Override
    public void visitNamespaces(String srcNamespace, List<String> dstNamespaces) {
    }

    @Override
    public boolean visitClass(String srcName) {
        this.srcClassName = srcName;
        return true;
    }

    @Override
    public boolean visitField(String srcName, String srcDesc) throws IOException {
        this.writeIndent(0);
        this.writer.write("FIELD ");
        this.writer.write(srcName);
        this.desc = srcDesc;
        return true;
    }

    @Override
    public boolean visitMethod(String srcName, String srcDesc) throws IOException {
        this.writeIndent(0);
        this.writer.write("METHOD ");
        this.writer.write(srcName);
        this.desc = srcDesc;
        return true;
    }

    @Override
    public boolean visitMethodArg(int argPosition, int lvIndex, String srcName) throws IOException {
        this.writeIndent(1);
        this.writer.write("ARG ");
        this.writer.write(Integer.toString(lvIndex));
        return true;
    }

    @Override
    public boolean visitMethodVar(int lvtRowIndex, int lvIndex, int startOpIdx, String srcName) {
        return false;
    }

    @Override
    public boolean visitEnd() throws IOException {
        this.close();
        return true;
    }

    @Override
    public void visitDstName(MappedElementKind targetKind, int namespace, String name) throws IOException {
        if (namespace != 0) {
            return;
        }
        if (targetKind == MappedElementKind.CLASS) {
            this.dstName = name;
        } else {
            this.writer.write(32);
            this.writer.write(name);
        }
    }

    @Override
    public boolean visitElementContent(MappedElementKind targetKind) throws IOException {
        if (targetKind == MappedElementKind.CLASS) {
            int srcEnd;
            String name;
            String string = name = this.dstName != null ? this.dstName : this.srcClassName;
            if (this.writerClass == null || !name.startsWith(this.writerClass) || name.length() > this.writerClass.length() && name.charAt(this.writerClass.length()) != '$') {
                Path file;
                int pos = EnigmaWriter.getNextOuterEnd(name, 0);
                if (pos >= 0) {
                    name = name.substring(0, pos);
                }
                if (!(file = this.dir.resolve(name + ".mapping").normalize()).startsWith(this.dir)) {
                    throw new RuntimeException("invalid name: " + name);
                }
                if (this.writer != null) {
                    this.writer.close();
                }
                this.writerClass = name;
                if (Files.exists(file, new LinkOption[0])) {
                    ArrayList<String> writtenClassParts = new ArrayList<String>();
                    try (BufferedReader reader = Files.newBufferedReader(file);){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            int offset;
                            for (offset = 0; offset < line.length() && line.charAt(offset) == '\t'; ++offset) {
                            }
                            if (!line.startsWith("CLASS ", offset)) continue;
                            int start = offset + 6;
                            int end = line.indexOf(32, start);
                            if (end < 0) {
                                end = line.length();
                            }
                            String part = line.substring(start, end);
                            while (writtenClassParts.size() > offset) {
                                writtenClassParts.remove(writtenClassParts.size() - 1);
                            }
                            writtenClassParts.add(part);
                        }
                    }
                    this.writtenClass = String.join((CharSequence)"$", writtenClassParts);
                } else {
                    this.writtenClass = "";
                    Files.createDirectories(file.getParent(), new FileAttribute[0]);
                }
                this.writer = Files.newBufferedWriter(file, StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
            }
            this.indent = 0;
            int srcStart = 0;
            do {
                int srcLen;
                if ((srcEnd = EnigmaWriter.getNextOuterEnd(this.srcClassName, srcStart)) < 0) {
                    srcEnd = this.srcClassName.length();
                }
                if (!this.writtenClass.regionMatches(srcStart, this.srcClassName, srcStart, srcLen = srcEnd - srcStart) || srcEnd < this.writtenClass.length() && this.writtenClass.charAt(srcEnd) != '$') {
                    this.writeIndent(0);
                    this.writer.write("CLASS ");
                    this.writer.write(this.srcClassName, srcStart, srcLen);
                    if (this.dstName != null) {
                        int dstStart = 0;
                        for (int i = 0; i < this.indent && (dstStart = EnigmaWriter.getNextOuterEnd(this.dstName, dstStart)) >= 0; ++i) {
                            ++dstStart;
                        }
                        if (dstStart >= 0) {
                            int dstLen;
                            int dstEnd = EnigmaWriter.getNextOuterEnd(this.dstName, dstStart);
                            if (dstEnd < 0) {
                                dstEnd = this.dstName.length();
                            }
                            if ((dstLen = dstEnd - dstStart) != srcLen || !this.srcClassName.regionMatches(srcStart, this.dstName, dstStart, srcLen)) {
                                this.writer.write(32);
                                this.writer.write(this.dstName, dstStart, dstLen);
                            }
                        }
                    }
                    this.writer.write(10);
                }
                ++this.indent;
            } while ((srcStart = srcEnd + 1) < this.srcClassName.length());
            this.writtenClass = this.srcClassName;
            this.dstName = null;
        } else if (targetKind == MappedElementKind.FIELD || targetKind == MappedElementKind.METHOD) {
            this.writer.write(32);
            this.writer.write(this.desc);
            this.writer.write(10);
        } else {
            this.writer.write(10);
        }
        return true;
    }

    private static int getNextOuterEnd(String name, int startPos) {
        int pos;
        while ((pos = name.indexOf(36, startPos + 1)) > 0) {
            if (name.charAt(pos - 1) != '/') {
                return pos;
            }
            startPos = pos + 1;
        }
        return -1;
    }

    @Override
    public void visitComment(MappedElementKind targetKind, String comment) throws IOException {
        int start = 0;
        while (start < comment.length()) {
            int pos = comment.indexOf(10, start);
            int end = pos >= 0 ? pos : comment.length();
            this.writeIndent(targetKind.level);
            this.writer.write("COMMENT");
            if (end > start) {
                this.writer.write(32);
                for (int i = start; i < end; ++i) {
                    char c2 = comment.charAt(i);
                    int idx = toEscape.indexOf(c2);
                    if (idx < 0) continue;
                    if (i > start) {
                        this.writer.write(comment, start, i - start);
                    }
                    this.writer.write(92);
                    this.writer.write(escaped.charAt(idx));
                    start = i + 1;
                }
                if (start < end) {
                    this.writer.write(comment, start, end - start);
                }
            }
            this.writer.write(10);
            start = end + 1;
            if (pos >= 0) continue;
        }
    }

    private void writeIndent(int extra) throws IOException {
        for (int i = 0; i < this.indent + extra; ++i) {
            this.writer.write(9);
        }
    }
}

