/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.transform;

import com.dfsek.terra.api.transform.Transform;
import com.dfsek.terra.api.transform.exception.TransformException;
import java.util.HashMap;
import java.util.Map;

public class MapTransform<F, T>
implements Transform<F, T> {
    private final Map<F, T> map;

    public MapTransform(Map<F, T> map) {
        this.map = map;
    }

    public MapTransform() {
        this.map = new HashMap<F, T>();
    }

    public MapTransform<F, T> add(F from, T to) {
        this.map.put(from, to);
        return this;
    }

    public MapTransform<F, T> remove(F from) {
        this.map.remove(from);
        return this;
    }

    @Override
    public T transform(F input) throws TransformException {
        if (!this.map.containsKey(input)) {
            throw new TransformException("No key matching " + input.toString() + " found in map.");
        }
        return this.map.get(input);
    }
}

