/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.lib.paralithic.eval.tokenizer;

import com.dfsek.terra.lib.paralithic.eval.tokenizer.Char;
import com.dfsek.terra.lib.paralithic.eval.tokenizer.Lookahead;
import com.dfsek.terra.lib.paralithic.eval.tokenizer.ParseError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class LookaheadReader
extends Lookahead<Char> {
    private final Reader input;
    private int line = 1;
    private int pos = 0;

    public LookaheadReader(Reader input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        this.input = new BufferedReader(input);
    }

    @Override
    protected Char fetch() {
        try {
            int character = this.input.read();
            if (character == -1) {
                return null;
            }
            Char result = new Char((char)character, this.line, this.pos++);
            if (character == 10) {
                ++this.line;
                this.pos = 0;
            }
            return result;
        }
        catch (IOException e2) {
            this.problemCollector.add(ParseError.error(new Char('\u0000', this.line, this.pos), e2.getMessage()));
            return null;
        }
    }

    @Override
    protected Char endOfInput() {
        return new Char('\u0000', this.line, this.pos);
    }

    public String toString() {
        if (this.itemBuffer.isEmpty()) {
            return this.line + ":" + this.pos + ": Buffer empty";
        }
        if (this.itemBuffer.size() < 2) {
            return this.line + ":" + this.pos + ": " + this.current();
        }
        return this.line + ":" + this.pos + ": " + this.current() + ", " + this.next();
    }
}

