/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.lib.paralithic.eval.parser;

import com.dfsek.terra.lib.paralithic.eval.parser.NamedConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class Scope {
    private static Scope root;
    private Scope parent;
    private final Map<String, NamedConstant> context = new ConcurrentHashMap<String, NamedConstant>();
    private final List<String> invocationVars = new ArrayList<String>();

    public Scope() {
        this(false);
    }

    private Scope(boolean skipParent) {
        if (!skipParent) {
            this.parent = Scope.getRootScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Scope getRootScope() {
        if (root != null) return root;
        Class<Scope> clazz = Scope.class;
        synchronized (Scope.class) {
            root = new Scope(true);
            root.create("pi", Math.PI);
            root.create("euler", Math.E);
            // ** MonitorExit[var0] (shouldn't be in output)
            return root;
        }
    }

    public Scope withParent(Scope parent) {
        this.parent = parent == null ? Scope.getRootScope() : parent;
        return this;
    }

    public NamedConstant create(String name, double value) {
        NamedConstant result = new NamedConstant(name, value);
        this.context.put(name, result);
        return result;
    }

    public void addInvocationVariable(String name) {
        if (this.invocationVars.contains(name) || this.find(name) != null) {
            throw new IllegalArgumentException("constant \"" + name + "\" already defined in this scope.");
        }
        this.invocationVars.add(name);
    }

    public void removeInvocationVariable(String name) {
        this.invocationVars.remove(name);
    }

    public int getInvocationVarIndex(String name) {
        return this.invocationVars.indexOf(name);
    }

    public NamedConstant find(String name) {
        if (this.context.containsKey(name)) {
            return this.context.get(name);
        }
        if (this.parent != null) {
            return this.parent.find(name);
        }
        return null;
    }

    public NamedConstant remove(String name) {
        if (this.context.containsKey(name)) {
            return this.context.remove(name);
        }
        return null;
    }

    public Set<String> getLocalNames() {
        return this.context.keySet();
    }

    public Set<String> getNames() {
        if (this.parent == null) {
            return this.getLocalNames();
        }
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(this.parent.getNames());
        result.addAll(this.getLocalNames());
        return result;
    }

    public Collection<NamedConstant> getLocalConstants() {
        return this.context.values();
    }

    public Collection<NamedConstant> getConstants() {
        if (this.parent == null) {
            return this.getLocalConstants();
        }
        ArrayList<NamedConstant> result = new ArrayList<NamedConstant>();
        result.addAll(this.parent.getConstants());
        result.addAll(this.getLocalConstants());
        return result;
    }
}

