/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.lib.google.common.hash;

import com.dfsek.terra.lib.google.common.base.Preconditions;
import com.dfsek.terra.lib.google.common.hash.Funnel;
import com.dfsek.terra.lib.google.common.hash.Hasher;
import com.dfsek.terra.lib.google.common.hash.Java8Compatibility;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@CanIgnoreReturnValue
abstract class AbstractHasher
implements Hasher {
    AbstractHasher() {
    }

    @Override
    public final Hasher putBoolean(boolean b2) {
        return this.putByte(b2 ? (byte)1 : 0);
    }

    @Override
    public final Hasher putDouble(double d) {
        return this.putLong(Double.doubleToRawLongBits(d));
    }

    @Override
    public final Hasher putFloat(float f) {
        return this.putInt(Float.floatToRawIntBits(f));
    }

    @Override
    public Hasher putUnencodedChars(CharSequence charSequence) {
        int len = charSequence.length();
        for (int i = 0; i < len; ++i) {
            this.putChar(charSequence.charAt(i));
        }
        return this;
    }

    @Override
    public Hasher putString(CharSequence charSequence, Charset charset) {
        return this.putBytes(charSequence.toString().getBytes(charset));
    }

    @Override
    public Hasher putBytes(byte[] bytes) {
        return this.putBytes(bytes, 0, bytes.length);
    }

    @Override
    public Hasher putBytes(byte[] bytes, int off, int len) {
        Preconditions.checkPositionIndexes(off, off + len, bytes.length);
        for (int i = 0; i < len; ++i) {
            this.putByte(bytes[off + i]);
        }
        return this;
    }

    @Override
    public Hasher putBytes(ByteBuffer b2) {
        if (b2.hasArray()) {
            this.putBytes(b2.array(), b2.arrayOffset() + b2.position(), b2.remaining());
            Java8Compatibility.position(b2, b2.limit());
        } else {
            for (int remaining = b2.remaining(); remaining > 0; --remaining) {
                this.putByte(b2.get());
            }
        }
        return this;
    }

    @Override
    public Hasher putShort(short s) {
        this.putByte((byte)s);
        this.putByte((byte)(s >>> 8));
        return this;
    }

    @Override
    public Hasher putInt(int i) {
        this.putByte((byte)i);
        this.putByte((byte)(i >>> 8));
        this.putByte((byte)(i >>> 16));
        this.putByte((byte)(i >>> 24));
        return this;
    }

    @Override
    public Hasher putLong(long l) {
        for (int i = 0; i < 64; i += 8) {
            this.putByte((byte)(l >>> i));
        }
        return this;
    }

    @Override
    public Hasher putChar(char c2) {
        this.putByte((byte)c2);
        this.putByte((byte)(c2 >>> 8));
        return this;
    }

    @Override
    public <T> Hasher putObject(T instance, Funnel<? super T> funnel) {
        funnel.funnel(instance, this);
        return this;
    }
}

